/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.primitives.Ints;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.DataManagerWrapper;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonUtils {
    @Nonnull
    public static final EquipmentSlotType[] ARMOR_SLOTS = new EquipmentSlotType[4];
    @Nonnull
    private static final Map<EquipmentSlotType, List<EnumPlayerPart>> slotToParts;

    public static List<EnumPlayerPart> getPartListForSlot(EquipmentSlotType slot) {
        return new ArrayList<EnumPlayerPart>((Collection)slotToParts.get(slot));
    }

    public static EnumPlayerPart[] getPartArrayForSlot(EquipmentSlotType slot) {
        return CommonUtils.getPartListForSlot(slot).toArray(new EnumPlayerPart[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killPlayer(@Nonnull AbstractPlayerDamageModel damageModel, @Nonnull PlayerEntity player, @Nullable DamageSource source) {
        if (player.field_70170_p.field_72995_K) {
            try {
                throw new RuntimeException("Tried to kill the player on the client!");
            }
            catch (RuntimeException e) {
                FirstAid.LOGGER.warn("Tried to kill the player on the client! This should only happen on the server! Ignoring...", (Throwable)e);
            }
        }
        if (source != null && ((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue()) {
            boolean protection;
            DataManagerWrapper wrapper = (DataManagerWrapper)player.field_70180_af;
            wrapper.toggleTracking(false);
            try {
                protection = player.func_190628_d(source);
            }
            finally {
                wrapper.toggleTracking(true);
            }
            if (protection) {
                for (AbstractDamageablePart part : damageModel) {
                    if (!part.canCauseDeath) continue;
                    part.currentHealth = Math.max(part.currentHealth, 1.0f);
                }
                if (player instanceof ServerPlayerEntity) {
                    FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncDamageModel(damageModel, false));
                }
                return;
            }
        }
        ((DataManagerWrapper)player.field_70180_af).set_impl(PlayerEntity.field_184632_c, Float.valueOf(0.0f));
    }

    public static boolean isValidArmorSlot(EquipmentSlotType slot) {
        return slot.func_188453_a() == EquipmentSlotType.Group.ARMOR;
    }

    public static boolean isSurvivalOrAdventure(PlayerEntity player) {
        return !player.func_175149_v() && !player.func_184812_l_();
    }

    @Nonnull
    public static String getActiveModidSafe() {
        ModContainer activeModContainer = ModLoadingContext.get().getActiveContainer();
        return activeModContainer == null ? "UNKNOWN-NULL" : activeModContainer.getModId();
    }

    public static void healPlayerByPercentage(double percentage, AbstractPlayerDamageModel damageModel, PlayerEntity player) {
        Objects.requireNonNull(damageModel);
        int healValue = Ints.checkedCast((long)Math.round((double)damageModel.getCurrentMaxHealth() * percentage));
        HealthDistribution.manageHealth(healValue, damageModel, player, true, false);
    }

    public static void debugLogStacktrace(String name) {
        if (!((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            return;
        }
        try {
            throw new RuntimeException("DEBUG:" + name);
        }
        catch (RuntimeException e) {
            FirstAid.LOGGER.info("DEBUG: " + name, (Throwable)e);
            return;
        }
    }

    @Nonnull
    public static AbstractPlayerDamageModel getDamageModel(PlayerEntity player) {
        return (AbstractPlayerDamageModel)player.getCapability(CapabilityExtendedHealthSystem.INSTANCE).orElseThrow(() -> new IllegalArgumentException("Player " + player.func_200200_C_().func_150261_e() + " is missing a damage model!"));
    }

    public static boolean hasDamageModel(Entity entity) {
        return entity instanceof PlayerEntity && !(entity instanceof FakePlayer);
    }

    @Nonnull
    public static ServerPlayerEntity checkServer(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalArgumentException("Wrong side for server packet handler " + context.getDirection());
        }
        context.setPacketHandled(true);
        return Objects.requireNonNull(context.getSender());
    }

    public static void checkClient(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            throw new IllegalArgumentException("Wrong side for client packet handler: " + context.getDirection());
        }
        context.setPacketHandled(true);
    }

    static {
        CommonUtils.ARMOR_SLOTS[3] = EquipmentSlotType.HEAD;
        CommonUtils.ARMOR_SLOTS[2] = EquipmentSlotType.CHEST;
        CommonUtils.ARMOR_SLOTS[1] = EquipmentSlotType.LEGS;
        CommonUtils.ARMOR_SLOTS[0] = EquipmentSlotType.FEET;
        slotToParts = new EnumMap<EquipmentSlotType, List<EnumPlayerPart>>(EquipmentSlotType.class);
        slotToParts.put(EquipmentSlotType.HEAD, Collections.singletonList(EnumPlayerPart.HEAD));
        slotToParts.put(EquipmentSlotType.CHEST, Arrays.asList(EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM, EnumPlayerPart.BODY));
        slotToParts.put(EquipmentSlotType.LEGS, Arrays.asList(EnumPlayerPart.LEFT_LEG, EnumPlayerPart.RIGHT_LEG));
        slotToParts.put(EquipmentSlotType.FEET, Arrays.asList(EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT));
    }
}

