/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.AABBAlignedBoundingBox;
import ichttt.mods.firstaid.common.damagesystem.distribution.StandardDamageDistribution;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerSizeHelper {
    private static final Map<EquipmentSlotType, AABBAlignedBoundingBox> NORMAL_BOXES;
    private static final Map<EquipmentSlotType, AABBAlignedBoundingBox> SNEAKING_BOXES;

    @Nonnull
    public static Map<EquipmentSlotType, AABBAlignedBoundingBox> getBoxes(Entity entity) {
        switch (entity.func_213283_Z()) {
            case STANDING: {
                return NORMAL_BOXES;
            }
            case CROUCHING: {
                return SNEAKING_BOXES;
            }
            case SPIN_ATTACK: 
            case FALL_FLYING: {
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    public static EquipmentSlotType getSlotTypeForProjectileHit(Entity hittingObject, PlayerEntity toTest) {
        float[] inflationSteps;
        Map<EquipmentSlotType, AABBAlignedBoundingBox> toUse = PlayerSizeHelper.getBoxes((Entity)toTest);
        Vector3d oldPosition = hittingObject.func_213303_ch();
        Vector3d newPosition = oldPosition.func_178787_e(hittingObject.func_213322_ci());
        for (float inflation : inflationSteps = new float[]{0.01f, 0.1f, 0.2f, 0.3f}) {
            EquipmentSlotType bestSlot = null;
            double bestValue = Double.MAX_VALUE;
            for (Map.Entry<EquipmentSlotType, AABBAlignedBoundingBox> entry : toUse.entrySet()) {
                double d2;
                double d1;
                AxisAlignedBB axisalignedbb = entry.getValue().createAABB(toTest.func_174813_aQ()).func_186662_g((double)inflation);
                Optional optional = axisalignedbb.func_216365_b(oldPosition, newPosition);
                if (!optional.isPresent() || !((d1 = oldPosition.func_72436_e((Vector3d)optional.get())) + (d2 = 0.0) < bestValue)) continue;
                bestSlot = entry.getKey();
                bestValue = d1 + d2;
            }
            if (bestSlot == null) continue;
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("getSlotTypeForProjectileHit: Inflation: " + inflation + " best slot: " + bestSlot);
            }
            return bestSlot;
        }
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("getSlotTypeForProjectileHit: Not found!");
        }
        return null;
    }

    public static IDamageDistribution getMeleeDistribution(PlayerEntity player, DamageSource source) {
        Map<EquipmentSlotType, AABBAlignedBoundingBox> boxes;
        MobEntity mobEntity;
        Entity causingEntity = source.func_76346_g();
        if (causingEntity != null && causingEntity == source.func_76364_f() && causingEntity instanceof MobEntity && (mobEntity = (MobEntity)causingEntity).func_70638_az() == player && mobEntity.field_70714_bg.func_220888_c().anyMatch(prioritizedGoal -> prioritizedGoal.func_220772_j() instanceof MeleeAttackGoal) && !(boxes = PlayerSizeHelper.getBoxes((Entity)player)).isEmpty()) {
            ArrayList<EquipmentSlotType> allowedParts = new ArrayList<EquipmentSlotType>();
            AxisAlignedBB modAABB = mobEntity.func_174813_aQ().func_72314_b((double)(mobEntity.func_213311_cf() * 2.0f + player.func_213311_cf()), 0.0, (double)(mobEntity.func_213311_cf() * 2.0f + player.func_213311_cf()));
            for (Map.Entry<EquipmentSlotType, AABBAlignedBoundingBox> entry : boxes.entrySet()) {
                AxisAlignedBB partAABB = entry.getValue().createAABB(player.func_174813_aQ());
                if (!modAABB.func_72326_a(partAABB)) continue;
                allowedParts.add(entry.getKey());
            }
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("getMeleeDistribution: Has distribution with {}", allowedParts);
            }
            if (allowedParts.isEmpty() && player.func_226278_cu_() > mobEntity.func_226278_cu_() && player.func_226278_cu_() - mobEntity.func_226278_cu_() < (double)(mobEntity.func_213302_cg() * 2.0f)) {
                if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                    FirstAid.LOGGER.info("Hack adding feet");
                }
                allowedParts.add(EquipmentSlotType.FEET);
            }
            if (!allowedParts.isEmpty() && !allowedParts.containsAll(Arrays.asList(CommonUtils.ARMOR_SLOTS))) {
                ArrayList<Pair<EquipmentSlotType, EnumPlayerPart[]>> list = new ArrayList<Pair<EquipmentSlotType, EnumPlayerPart[]>>();
                for (EquipmentSlotType allowedPart : allowedParts) {
                    list.add((Pair<EquipmentSlotType, EnumPlayerPart[]>)Pair.of((Object)allowedPart, (Object)CommonUtils.getPartArrayForSlot(allowedPart)));
                }
                return new StandardDamageDistribution(list, true, true);
            }
        }
        return null;
    }

    static {
        LinkedHashMap<EquipmentSlotType, AABBAlignedBoundingBox> builder = new LinkedHashMap<EquipmentSlotType, AABBAlignedBoundingBox>();
        builder.put(EquipmentSlotType.FEET, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(EquipmentSlotType.LEGS, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.45, 1.0));
        builder.put(EquipmentSlotType.CHEST, new AABBAlignedBoundingBox(0.0, 0.45, 0.0, 1.0, 0.8, 1.0));
        builder.put(EquipmentSlotType.HEAD, new AABBAlignedBoundingBox(0.0, 0.8, 0.0, 1.0, 1.0, 1.0));
        NORMAL_BOXES = Collections.unmodifiableMap(builder);
        builder = new LinkedHashMap();
        builder.put(EquipmentSlotType.FEET, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(EquipmentSlotType.LEGS, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.4, 1.0));
        builder.put(EquipmentSlotType.CHEST, new AABBAlignedBoundingBox(0.0, 0.4, 0.0, 1.0, 0.75, 1.0));
        builder.put(EquipmentSlotType.HEAD, new AABBAlignedBoundingBox(0.0, 0.75, 0.0, 1.0, 1.0, 1.0));
        SNEAKING_BOXES = Collections.unmodifiableMap(builder);
    }
}

