/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.block.BlockFloowerPot;
import com.fredtargaryen.floocraft.block.FlooCampfireBlock;
import com.fredtargaryen.floocraft.block.FlooFlamesBusy;
import com.fredtargaryen.floocraft.block.FlooFlamesIdle;
import com.fredtargaryen.floocraft.block.FlooFlamesTemp;
import com.fredtargaryen.floocraft.block.FlooSignBlock;
import com.fredtargaryen.floocraft.block.FlooTorchBlock;
import com.fredtargaryen.floocraft.client.particle.GreenFlameParticle;
import com.fredtargaryen.floocraft.command.CommandsBase;
import com.fredtargaryen.floocraft.config.Config;
import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.inventory.container.FloowerPotContainer;
import com.fredtargaryen.floocraft.item.ItemFlooPowder;
import com.fredtargaryen.floocraft.item.ItemFlooSign;
import com.fredtargaryen.floocraft.item.ItemFlooTorch;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import com.fredtargaryen.floocraft.proxy.IProxy;
import com.fredtargaryen.floocraft.proxy.ServerProxy;
import com.fredtargaryen.floocraft.tileentity.FireplaceTileEntity;
import com.fredtargaryen.floocraft.tileentity.FloowerPotTileEntity;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="floocraftft")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FloocraftBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"floocraftft");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"floocraftft");
    private static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"floocraftft");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"floocraftft");
    private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"floocraftft");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"floocraftft");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"floocraftft");
    public static final RegistryObject<Block> BLOCK_FLOO_TORCH = BLOCKS.register("flootorch", FlooTorchBlock::new);
    public static final RegistryObject<Block> GREEN_FLAMES_BUSY = BLOCKS.register("greenflamesbusy", () -> new FlooFlamesBusy(15));
    public static final RegistryObject<Block> GREEN_FLAMES_IDLE = BLOCKS.register("greenflamesidle", () -> new FlooFlamesIdle(12));
    public static final RegistryObject<Block> GREEN_FLAMES_TEMP = BLOCKS.register("greenflamestemp", () -> new FlooFlamesTemp(15));
    public static final RegistryObject<Block> MAGENTA_FLAMES_BUSY = BLOCKS.register("magentaflamesbusy", () -> new FlooFlamesBusy(10));
    public static final RegistryObject<Block> MAGENTA_FLAMES_IDLE = BLOCKS.register("magentaflamesidle", () -> new FlooFlamesIdle(7));
    public static final RegistryObject<Block> MAGENTA_FLAMES_TEMP = BLOCKS.register("magentaflamestemp", () -> new FlooFlamesTemp(10));
    public static final RegistryObject<Block> FLOO_CAMPFIRE = BLOCKS.register("floo_campfire", () -> new FlooCampfireBlock(15));
    public static final RegistryObject<Block> FLOO_SOUL_CAMPFIRE = BLOCKS.register("floo_soul_campfire", () -> new FlooCampfireBlock(10));
    public static final RegistryObject<Block> BLOCK_FLOO_SIGN = BLOCKS.register("floosign", FlooSignBlock::new);
    public static final RegistryObject<Block> FLOOWER_POT = BLOCKS.register("floowerpot", BlockFloowerPot::new);
    public static final RegistryObject<Item> ITEM_FLOO_SIGN = ITEMS.register("floosign", () -> new ItemFlooSign(new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(16)));
    public static final RegistryObject<Item> ITEM_FLOO_TORCH = ITEMS.register("flootorch", ItemFlooTorch::new);
    public static final RegistryObject<Item> ITEM_FLOOWER_POT = ITEMS.register("floowerpot", () -> new BlockItem((Block)FLOOWER_POT.get(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<Item> ITEM_FLOO_POWDER_1 = ITEMS.register("floopowder_one", () -> new ItemFlooPowder(1));
    public static final RegistryObject<Item> ITEM_FLOO_POWDER_2 = ITEMS.register("floopowder_two", () -> new ItemFlooPowder(2));
    public static final RegistryObject<Item> ITEM_FLOO_POWDER_4 = ITEMS.register("floopowder_four", () -> new ItemFlooPowder(4));
    public static final RegistryObject<Item> ITEM_FLOO_POWDER_8 = ITEMS.register("floopowder_eight", () -> new ItemFlooPowder(8));
    public static final RegistryObject<Item> ITEM_FLOO_POWDER_INFINITE = ITEMS.register("floopowder_infinite", () -> new ItemFlooPowder(9));
    public static final RegistryObject<ContainerType<FloowerPotContainer>> POT_CONTAINER_TYPE = CONTAINER_TYPES.register("pot", () -> IForgeContainerType.create((windowId, inv, data) -> new FloowerPotContainer(windowId, inv, inv.field_70458_d.field_70170_p, data.func_179259_c())));
    public static final RegistryObject<EntityType<PeekerEntity>> PEEKER_TYPE = ENTITY_TYPES.register("peeker", () -> EntityType.Builder.func_220322_a((type, world) -> new PeekerEntity(world), (EntityClassification)EntityClassification.MISC).setTrackingRange(32).setUpdateInterval(10).setShouldReceiveVelocityUpdates(false).func_220320_c().func_220321_a(0.5f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new PeekerEntity((World)world)).func_206830_a("floocraftft"));
    public static final RegistryObject<BasicParticleType> GREEN_FLAME = PARTICLE_TYPES.register("greenflame", () -> new BasicParticleType(false));
    public static final RegistryObject<SoundEvent> GREENED = SOUND_EVENTS.register("greened", () -> new SoundEvent(DataReference.GREENED_RL));
    public static final RegistryObject<SoundEvent> TP = SOUND_EVENTS.register("tp", () -> new SoundEvent(DataReference.TP_RL));
    public static final RegistryObject<SoundEvent> FLICK = SOUND_EVENTS.register("flick", () -> new SoundEvent(DataReference.FLICK_RL));
    public static final RegistryObject<TileEntityType<FireplaceTileEntity>> FIREPLACE_TYPE = TILE_ENTITY_TYPES.register("fireplace", () -> TileEntityType.Builder.func_223042_a(FireplaceTileEntity::new, (Block[])new Block[]{(Block)BLOCK_FLOO_SIGN.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<FloowerPotTileEntity>> POT_TYPE = TILE_ENTITY_TYPES.register("pot", () -> TileEntityType.Builder.func_223042_a(FloowerPotTileEntity::new, (Block[])new Block[]{(Block)FLOOWER_POT.get()}).func_206865_a(null));
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());

    public FloocraftBase() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus loadingBus = FMLJavaModLoadingContext.get().getModEventBus();
        loadingBus.addListener(this::postRegistration);
        loadingBus.addListener(this::clientSetup);
        BLOCKS.register(loadingBus);
        ITEMS.register(loadingBus);
        CONTAINER_TYPES.register(loadingBus);
        ENTITY_TYPES.register(loadingBus);
        PARTICLE_TYPES.register(loadingBus);
        SOUND_EVENTS.register(loadingBus);
        TILE_ENTITY_TYPES.register(loadingBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG_SPEC);
        Config.loadConfig(Config.CLIENT_CONFIG_SPEC, FMLPaths.CONFIGDIR.get().resolve("floocraftft-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG_SPEC, FMLPaths.CONFIGDIR.get().resolve("floocraftft-common.toml"));
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)GREEN_FLAME.get(), GreenFlameParticle.Factory::new);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandsBase.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public void postRegistration(FMLCommonSetupEvent event) {
        MessageHandler.init();
        proxy.registerTickHandlers();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        proxy.registerGUIs();
        proxy.registerRenderers();
        proxy.setupRenderTypes();
    }

    @SubscribeEvent
    public static void handleMissingMappings(RegistryEvent.MissingMappings evt) {
        block57: {
            String fullName;
            block59: {
                block58: {
                    block56: {
                        fullName = evt.getName().toString();
                        if (!fullName.equals("minecraft:blocks")) break block56;
                        for (Object mapping : evt.getAllMappings()) {
                            RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                            if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                            switch (trueMapping.key.func_110623_a()) {
                                case "flootorch": {
                                    trueMapping.remap(BLOCK_FLOO_TORCH.get());
                                    break;
                                }
                                case "greenflamesbusy": {
                                    trueMapping.remap(GREEN_FLAMES_BUSY.get());
                                    break;
                                }
                                case "greenflamesidle": {
                                    trueMapping.remap(GREEN_FLAMES_IDLE.get());
                                    break;
                                }
                                case "greenflamestemp": {
                                    trueMapping.remap(GREEN_FLAMES_TEMP.get());
                                    break;
                                }
                                case "blockfloosign": {
                                    trueMapping.remap(BLOCK_FLOO_SIGN.get());
                                    break;
                                }
                                case "floowerpot": {
                                    trueMapping.remap(FLOOWER_POT.get());
                                    break;
                                }
                            }
                        }
                        break block57;
                    }
                    if (!fullName.equals("minecraft:items")) break block58;
                    for (Object mapping : evt.getAllMappings()) {
                        RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                        if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                        switch (trueMapping.key.func_110623_a()) {
                            case "flootorch": {
                                trueMapping.remap(ITEM_FLOO_TORCH.get());
                                break;
                            }
                            case "floowerpot": {
                                trueMapping.remap(ITEM_FLOOWER_POT.get());
                                break;
                            }
                            case "floopowder_one": {
                                trueMapping.remap(ITEM_FLOO_POWDER_1.get());
                                break;
                            }
                            case "floopowder_two": {
                                trueMapping.remap(ITEM_FLOO_POWDER_2.get());
                                break;
                            }
                            case "floopowder_four": {
                                trueMapping.remap(ITEM_FLOO_POWDER_4.get());
                                break;
                            }
                            case "floopowder_eight": {
                                trueMapping.remap(ITEM_FLOO_POWDER_8.get());
                                break;
                            }
                            case "floopowder_infinite": {
                                trueMapping.remap(ITEM_FLOO_POWDER_INFINITE.get());
                                break;
                            }
                            case "itemfloosign": {
                                trueMapping.remap(ITEM_FLOO_SIGN.get());
                                break;
                            }
                        }
                    }
                    break block57;
                }
                if (!fullName.equals("minecraft:entities")) break block59;
                for (Object mapping : evt.getAllMappings()) {
                    RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                    if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                    switch (trueMapping.key.func_110623_a()) {
                        case "peeker": {
                            trueMapping.remap(ForgeRegistries.ENTITIES.getValue(((EntityType)PEEKER_TYPE.get()).getRegistryName()));
                            break;
                        }
                    }
                }
                break block57;
            }
            if (!fullName.equals("minecraft:soundevents")) break block57;
            for (Object mapping : evt.getAllMappings()) {
                RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                switch (trueMapping.key.func_110623_a()) {
                    case "tp": {
                        trueMapping.remap(TP.get());
                        break;
                    }
                    case "flick": {
                        trueMapping.remap(FLICK.get());
                        break;
                    }
                    case "greened": {
                        trueMapping.remap(GREENED.get());
                        break;
                    }
                }
            }
        }
    }

    public static void info(String message) {
        LOGGER.info(message);
    }

    public static void warn(String message) {
        LOGGER.warn(message);
    }
}

