/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.FlooFlamesBase;
import com.fredtargaryen.floocraft.item.ItemFlooPowder;
import com.fredtargaryen.floocraft.tileentity.FloowerPotTileEntity;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockFloowerPot
extends Block {
    private static final VoxelShape POTBOX = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public BlockFloowerPot() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return POTBOX;
    }

    public boolean hasTileEntity(BlockState ibs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FloowerPotTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null || player.func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        this.dropItems(worldIn, pos);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item.func_190926_b() || item.func_190916_E() <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            ItemEntity ItemEntity2 = new ItemEntity(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack((IItemProvider)item.func_77973_b(), item.func_190916_E(), item.func_77978_p()));
            if (item.func_77942_o()) {
                ItemEntity2.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            ItemEntity2.func_213293_j(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
            world.func_217376_c((Entity)ItemEntity2);
            item.func_190920_e(0);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        if (!world.field_72995_K) {
            FloowerPotTileEntity pot = (FloowerPotTileEntity)world.func_175625_s(pos);
            int hRange = pot.getHRange();
            int vRange = pot.getVRange();
            ItemStack stack = pot.func_70301_a(0);
            if (stack != null && stack.func_190916_E() > 0) {
                int par2 = pos.func_177958_n();
                int par3 = pos.func_177956_o();
                int par4 = pos.func_177952_p();
                Block greenBusy = (Block)FloocraftBase.GREEN_FLAMES_BUSY.get();
                BlockState greenState = greenBusy.func_176223_P();
                BlockState magentaState = ((Block)FloocraftBase.MAGENTA_FLAMES_BUSY.get()).func_176223_P();
                SoundEvent greened = (SoundEvent)FloocraftBase.GREENED.get();
                for (int x = par2 - hRange; x <= par2 + hRange; ++x) {
                    for (int y = par3 - vRange; y <= par3 + vRange; ++y) {
                        for (int z = par4 - hRange; z <= par4 + hRange; ++z) {
                            Item i;
                            if (stack == null || stack.func_190916_E() <= 0) continue;
                            BlockPos currentPos = new BlockPos(x, y, z);
                            BlockState currentState = world.func_180495_p(currentPos);
                            Block currentBlock = currentState.func_177230_c();
                            if (currentBlock == Blocks.field_222433_lV && ((Boolean)currentState.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
                                i = stack.func_77973_b();
                                world.func_175656_a(currentPos, (BlockState)((BlockState)((Block)FloocraftBase.FLOO_CAMPFIRE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(((ItemFlooPowder)i).getConcentration()))).func_206870_a((Property)BlockStateProperties.field_208157_J, currentState.func_177229_b((Property)BlockStateProperties.field_208157_J)));
                                world.func_184133_a(null, currentPos, greened, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                stack = stack.func_190916_E() == 1 ? ItemStack.field_190927_a : stack.func_77979_a(stack.func_190916_E() - 1);
                                continue;
                            }
                            if (currentBlock == Blocks.field_235367_mf_ && ((Boolean)currentState.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
                                i = stack.func_77973_b();
                                world.func_175656_a(currentPos, (BlockState)((BlockState)((Block)FloocraftBase.FLOO_SOUL_CAMPFIRE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(((ItemFlooPowder)i).getConcentration()))).func_206870_a((Property)BlockStateProperties.field_208157_J, currentState.func_177229_b((Property)BlockStateProperties.field_208157_J)));
                                world.func_184133_a(null, currentPos, greened, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                stack = stack.func_190916_E() == 1 ? ItemStack.field_190927_a : stack.func_77979_a(stack.func_190916_E() - 1);
                                continue;
                            }
                            if (!currentBlock.func_203417_a((ITag)BlockTags.field_232872_am_) || ((FlooFlamesBase)greenBusy).isInFireplace((World)world, currentPos) == null) continue;
                            i = stack.func_77973_b();
                            boolean soul = SoulFireBlock.func_235577_c_((Block)world.func_180495_p(currentPos.func_177977_b()).func_177230_c());
                            BlockState stateToSet = soul ? magentaState : greenState;
                            world.func_180501_a(currentPos, (BlockState)stateToSet.func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(((ItemFlooPowder)i).getConcentration())), 3);
                            world.func_184133_a(null, currentPos, greened, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            stack = stack.func_190916_E() == 1 ? ItemStack.field_190927_a : stack.func_77979_a(stack.func_190916_E() - 1);
                        }
                    }
                }
            }
            pot.func_70299_a(0, stack);
            world.func_184138_a(pos, state, state, 3);
            world.func_205220_G_().func_205362_a(pos, (Object)state.func_177230_c(), 50 + rand.nextInt(100), TickPriority.EXTREMELY_LOW);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean b) {
        worldIn.func_205220_G_().func_205362_a(pos, (Object)state.func_177230_c(), 50, TickPriority.EXTREMELY_LOW);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return super.func_196260_a(state, worldIn, pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        if (!this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            this.func_196243_a(state, worldIn, pos, Blocks.field_150350_a.func_176223_P(), false);
        }
    }
}

