/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.FlooFlamesBase;
import com.fredtargaryen.floocraft.client.gui.TeleportScreen;
import com.fredtargaryen.floocraft.config.CommonConfig;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class FlooMainTeleporterBase
extends Block {
    public FlooMainTeleporterBase(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208171_X});
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            if (entityIn == Minecraft.func_71410_x().field_71439_g) {
                this.doClientGuiTings(pos);
            }
        } else if (!(entityIn instanceof PlayerEntity)) {
            boolean teleport = false;
            boolean landOutside = false;
            if (((Boolean)CommonConfig.ITEMS_TELEPORT.get()).booleanValue() && entityIn instanceof ItemEntity) {
                teleport = true;
                landOutside = true;
            } else if (((Boolean)CommonConfig.VILLAGERS_TELEPORT.get()).booleanValue() && entityIn instanceof VillagerEntity || ((Boolean)CommonConfig.MISC_MOBS_TELEPORT.get()).booleanValue() && entityIn instanceof LivingEntity) {
                boolean bl = teleport = (double)worldIn.field_73012_v.nextFloat() < 0.2;
            }
            if (teleport) {
                FloocraftWorldData fwd = FloocraftWorldData.forWorld(worldIn);
                MessageFireplaceList mfl = fwd.assembleNewFireplaceList(worldIn);
                ArrayList<String> possibleLocations = new ArrayList<String>();
                for (int i = 0; i < mfl.places.length; ++i) {
                    if (!mfl.enabledList[i]) continue;
                    possibleLocations.add((String)mfl.places[i]);
                }
                if (!possibleLocations.isEmpty()) {
                    int destNo = worldIn.field_73012_v.nextInt(possibleLocations.size());
                    String destName = (String)possibleLocations.get(destNo);
                    int[] coords = fwd.placeList.get(destName);
                    BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
                    Block blockOnTop = worldIn.func_180495_p(dest).func_177230_c();
                    if (blockOnTop.func_203417_a((ITag)BlockTags.field_232872_am_)) {
                        if (SoulFireBlock.func_235577_c_((Block)worldIn.func_180495_p(dest.func_177977_b()).func_177230_c())) {
                            worldIn.func_175656_a(dest, ((Block)FloocraftBase.MAGENTA_FLAMES_TEMP.get()).func_176223_P());
                        } else {
                            worldIn.func_175656_a(dest, ((Block)FloocraftBase.GREEN_FLAMES_TEMP.get()).func_176223_P());
                        }
                    }
                    if (landOutside) {
                        dest = dest.func_177972_a(((FlooFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP.get()).isInFireplace(worldIn, dest));
                        entityIn.func_70012_b((double)dest.func_177958_n(), (double)coords[1], (double)dest.func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
                    } else {
                        entityIn.func_70012_b((double)coords[0], (double)coords[1], (double)coords[2], entityIn.field_70177_z, entityIn.field_70125_A);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientGuiTings(BlockPos pos) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new TeleportScreen(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            proxy.overrideTicker.start();
        }
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }
}

