/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageEndPeek;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PeekScreen
extends Screen {
    private boolean peekerSpawned = false;
    private String fireplaceName;
    private Button doneBtn;
    private Entity player;
    private UUID peekerID;
    private boolean peekFailedOutOfRange;
    private static final TranslationTextComponent PEEK_DONE = new TranslationTextComponent("gui.peek.done");

    public PeekScreen(String name, UUID peekerID) {
        super((ITextComponent)new StringTextComponent(name));
        this.fireplaceName = name;
        this.peekerID = peekerID;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.peekFailedOutOfRange = false;
    }

    public void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        if (!this.peekerSpawned) {
            PeekerEntity ep = (PeekerEntity)FloocraftBase.proxy.getEntityWithUUID((World)this.field_230706_i_.field_71441_e, this.peekerID);
            if (ep == null) {
                this.peekFailedOutOfRange = true;
            } else {
                this.peekerSpawned = true;
                this.player = this.field_230706_i_.func_175606_aa();
                this.field_230706_i_.func_175607_a((Entity)ep);
            }
        }
        this.doneBtn = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 40, 200, 20, (ITextComponent)PEEK_DONE, button -> {
            this.func_231164_f_();
            Minecraft.func_71410_x().func_147108_a(null);
        });
        this.func_230480_a_((Widget)this.doneBtn);
        this.doneBtn.field_230693_o_ = true;
    }

    public void func_231164_f_() {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        proxy.overrideTicker.start();
        this.field_230706_i_.func_175607_a(this.player);
        MessageEndPeek mep = new MessageEndPeek();
        mep.peekerUUID = this.peekerID;
        MessageHandler.INSTANCE.sendToServer((Object)mep);
        super.func_231164_f_();
    }

    public boolean func_231042_a_(char par1, int par2) {
        if (par2 == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_230430_a_(MatrixStack stack, int mousex, int mousey, float partialticks) {
        PeekScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)(this.peekerSpawned ? I18n.func_135052_a((String)"gui.peek.peeking", (Object[])new Object[]{this.fireplaceName}) : (this.peekFailedOutOfRange ? I18n.func_135052_a((String)"gui.peek.outofrange", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.peek.waiting", (Object[])new Object[0]))), (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
        super.func_230430_a_(stack, mousex, mousey, partialticks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent lhe) {
        if (lhe.getEntity() == this.player) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent lde) {
        if (lde.getEntity() == this.player) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }
}

