/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.PeekScreen;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceListRequest;
import com.fredtargaryen.floocraft.network.messages.MessagePeekRequest;
import com.fredtargaryen.floocraft.network.messages.MessageStartPeek;
import com.fredtargaryen.floocraft.network.messages.MessageTeleportEntity;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class TeleportScreen
extends Screen {
    private static final String screenTitle = I18n.func_135052_a((String)"gui.teleport.title", (Object[])new Object[0]);
    private String status;
    private Button peekBtn;
    private Button goBtn;
    private Button cancelBtn;
    private boolean[] enabledList;
    private boolean receivedLists;
    private PlaceScrollWindow scrollWindow;
    private final int initX;
    private final int initY;
    private final int initZ;
    private Object[] placeList;
    private int peekAttemptTimer;
    private static final TranslationTextComponent REFRESH = new TranslationTextComponent("gui.teleport.refresh");
    private static final TranslationTextComponent PEEK = new TranslationTextComponent("gui.teleport.peek");
    private static final TranslationTextComponent TELEPORT = new TranslationTextComponent("gui.teleport.go");
    private static final TranslationTextComponent CANCEL = new TranslationTextComponent("gui.teleport.cancel");

    public TeleportScreen(int x, int y, int z) {
        super((ITextComponent)new StringTextComponent(screenTitle));
        this.initX = x;
        this.initY = y;
        this.initZ = z;
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.peekAttemptTimer = 0;
        this.refresh();
    }

    public void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        Button refreshButton = new Button(this.field_230708_k_ - 100, 0, 98, 20, (ITextComponent)REFRESH, button -> {
            this.refresh();
            this.func_231160_c_();
        });
        refreshButton.field_230693_o_ = false;
        this.peekBtn = new Button(this.field_230708_k_ / 2 - 151, this.field_230709_l_ - 40, 98, 20, (ITextComponent)PEEK, button -> {
            String dest = (String)this.placeList[((GuiPlaceEntry)this.scrollWindow.func_230958_g_()).id];
            try {
                MessagePeekRequest m = new MessagePeekRequest();
                m.initX = this.initX;
                m.initY = this.initY;
                m.initZ = this.initZ;
                m.dest = dest;
                MessageHandler.INSTANCE.sendToServer((Object)m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.func_230480_a_((Widget)this.peekBtn);
        this.peekBtn.field_230693_o_ = false;
        this.goBtn = new Button(this.field_230708_k_ / 2 - 49, this.field_230709_l_ - 40, 98, 20, (ITextComponent)TELEPORT, button -> {
            int initX = this.initX;
            int initY = this.initY;
            int initZ = this.initZ;
            String dest = (String)this.placeList[((GuiPlaceEntry)this.scrollWindow.func_230958_g_()).id];
            try {
                MessageTeleportEntity m = new MessageTeleportEntity();
                m.initX = initX;
                m.initY = initY;
                m.initZ = initZ;
                m.dest = dest;
                MessageHandler.INSTANCE.sendToServer((Object)m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cancelBtn.func_230982_a_(0.0, 0.0);
        });
        this.func_230480_a_((Widget)this.goBtn);
        this.goBtn.field_230693_o_ = false;
        this.cancelBtn = new Button(this.field_230708_k_ / 2 + 53, this.field_230709_l_ - 40, 98, 20, (ITextComponent)CANCEL, button -> {
            ((ClientProxy)FloocraftBase.proxy).overrideTicker.start();
            this.field_230706_i_.func_147108_a(null);
        });
        this.func_230480_a_((Widget)this.cancelBtn);
        if (this.receivedLists) {
            refreshButton.field_230693_o_ = true;
            this.scrollWindow = new PlaceScrollWindow();
            this.field_230705_e_.add(this.scrollWindow);
        }
        this.func_230480_a_((Widget)refreshButton);
    }

    public void func_231164_f_() {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        proxy.overrideTicker.start();
        super.func_231164_f_();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.receivedLists) {
            this.status = I18n.func_135052_a((String)"gui.teleport.loading", (Object[])new Object[0]);
        } else if (this.placeList.length == 0) {
            this.status = I18n.func_135052_a((String)"gui.teleport.empty", (Object[])new Object[0]);
        } else if (this.peekAttemptTimer == 0) {
            this.status = "";
        }
        if (this.peekAttemptTimer > 0) {
            --this.peekAttemptTimer;
        }
    }

    public boolean func_231042_a_(char par1, int par2) {
        if (par2 == 1) {
            this.cancelBtn.func_230982_a_(0.0, 0.0);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_230430_a_(MatrixStack stack, int mousex, int mousey, float partialticks) {
        this.func_230446_a_(stack);
        TeleportScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.status, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 4 + 48), (int)0xC8C8C8);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_230708_k_ / 2), (float)0.0f, (float)50.0f);
        float f1 = 93.75f;
        GL11.glScalef((float)(-f1), (float)(-f1), (float)(-f1));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (this.scrollWindow != null) {
            this.scrollWindow.func_230430_a_(stack, mousex, mousey, partialticks);
        }
        TeleportScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)screenTitle, (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
        super.func_230430_a_(stack, mousex, mousey, partialticks);
    }

    private void refresh() {
        this.field_230705_e_.remove((Object)this.scrollWindow);
        this.scrollWindow = null;
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.receivedLists = false;
        MessageHandler.INSTANCE.sendToServer((Object)new MessageFireplaceListRequest());
    }

    public void onFireplaceList(MessageFireplaceList m) {
        try {
            this.placeList = m.places;
            this.enabledList = m.enabledList;
            this.receivedLists = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.func_231160_c_();
    }

    public void onStartPeek(MessageStartPeek msp) {
        this.field_230706_i_.func_147108_a((Screen)new PeekScreen((String)this.placeList[((GuiPlaceEntry)this.scrollWindow.func_230958_g_()).id], msp.peekerUUID));
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.scrollWindow != null) {
            this.scrollWindow.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    class PlaceScrollWindow
    extends ExtendedList<GuiPlaceEntry> {
        PlaceScrollWindow() {
            super(TeleportScreen.this.field_230706_i_, TeleportScreen.this.field_230708_k_, TeleportScreen.this.field_230709_l_, 32, TeleportScreen.this.field_230709_l_ - 64, 18);
            this.func_230943_a_(true);
            for (int i = 0; i < TeleportScreen.this.placeList.length; ++i) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new GuiPlaceEntry(i));
            }
            if (TeleportScreen.this.placeList.length > 0) {
                this.setSelected(null);
            }
        }

        public int getWidth() {
            return 380;
        }

        public void setSelected(GuiPlaceEntry entry) {
            super.func_241215_a_((AbstractList.AbstractListEntry)entry);
            if (entry != null) {
                boolean enabled;
                ((TeleportScreen)TeleportScreen.this).goBtn.field_230693_o_ = enabled = TeleportScreen.this.enabledList[entry.id];
                ((TeleportScreen)TeleportScreen.this).peekBtn.field_230693_o_ = enabled;
            }
        }

        protected boolean isSelected(int id) {
            return id == ((GuiPlaceEntry)this.func_230958_g_()).id;
        }

        protected int getContentHeight() {
            return this.getHeight() * 18;
        }

        protected void func_230433_a_(MatrixStack stack) {
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            int i = this.func_230952_d_();
            int j = i + 6;
            RenderSystem.disableLighting();
            RenderSystem.disableFog();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k = this.func_230968_n_();
            int l = this.field_230672_i_ + 4 - (int)this.func_230966_l_();
            this.func_238478_a_(stack, k, l, mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ZERO.field_225655_p_, (int)GlStateManager.DestFactor.ONE.field_225654_o_);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            int i1 = 4;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int j1 = Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
            if (j1 > 0) {
                int k1 = (int)((float)((this.field_230673_j_ - this.field_230672_i_) * (this.field_230673_j_ - this.field_230672_i_)) / (float)this.func_230945_b_());
                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_230673_j_ - this.field_230672_i_ - 8));
                int l1 = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - k1) / j1 + this.field_230672_i_;
                if (l1 < this.field_230672_i_) {
                    l1 = this.field_230672_i_;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.func_230447_a_(stack, mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            this.flooverlayBackground(0, this.getTop());
            this.flooverlayBackground(this.getBottom(), this.field_230671_e_);
        }

        private void flooverlayBackground(int p_148136_1_, int p_148136_2_) {
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            TeleportScreen.this.field_230706_i_.func_110434_K().func_110577_a(DataReference.TP_BACKGROUND);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_225582_a_(0.0, (double)p_148136_2_, 0.0).func_225583_a_(0.0f, (float)p_148136_2_ / f).func_181675_d();
            wr.func_225582_a_((double)this.field_230670_d_, (double)p_148136_2_, 0.0).func_225583_a_((float)this.field_230670_d_ / f, (float)p_148136_2_ / f).func_181675_d();
            wr.func_225582_a_((double)this.field_230670_d_, (double)p_148136_1_, 0.0).func_225583_a_((float)this.field_230670_d_ / f, (float)p_148136_1_ / f).func_181675_d();
            wr.func_225582_a_(0.0, (double)p_148136_1_, 0.0).func_225583_a_(0.0f, (float)p_148136_1_ / f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class GuiPlaceEntry
    extends ExtendedList.AbstractListEntry<GuiPlaceEntry> {
        private int id;

        GuiPlaceEntry(int id) {
            this.id = id;
        }

        public void func_230432_a_(MatrixStack stack, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean b, float partialTicks) {
            TeleportScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)TeleportScreen.this.field_230712_o_, (String)((String)TeleportScreen.this.placeList[this.id]), (int)(TeleportScreen.this.field_230708_k_ / 2), (int)(top + 3), (int)(TeleportScreen.this.enabledList[this.id] ? 65280 : 0xFF0000));
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            TeleportScreen.this.scrollWindow.setSelected(this);
            return true;
        }
    }
}

