/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.item;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.FlooFlamesBase;
import com.fredtargaryen.floocraft.entity.DroppedFlooPowderEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFlooPowder
extends Item {
    private final byte concentration;

    public byte getConcentration() {
        return this.concentration;
    }

    public ItemFlooPowder(byte conc) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(64));
        this.concentration = conc;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (!worldIn.field_72995_K) {
            BlockState state = worldIn.func_180495_p(pos);
            Block b = state.func_177230_c();
            if (b == Blocks.field_222433_lV && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((Block)FloocraftBase.FLOO_CAMPFIRE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, state.func_177229_b((Property)BlockStateProperties.field_208157_J))).func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(this.concentration)), 3);
                worldIn.func_184133_a(null, pos, (SoundEvent)FloocraftBase.GREENED.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                context.func_195996_i().func_190917_f(-1);
                return ActionResultType.SUCCESS;
            }
            if (b == Blocks.field_235367_mf_ && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((Block)FloocraftBase.FLOO_SOUL_CAMPFIRE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, state.func_177229_b((Property)BlockStateProperties.field_208157_J))).func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(this.concentration)), 3);
                worldIn.func_184133_a(null, pos, (SoundEvent)FloocraftBase.GREENED.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                context.func_195996_i().func_190917_f(-1);
                return ActionResultType.SUCCESS;
            }
            if (b.func_203417_a((ITag)BlockTags.field_232872_am_)) {
                if (((FlooFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP.get()).isInFireplace(worldIn, pos) != null) {
                    Block fireBlock = SoulFireBlock.func_235577_c_((Block)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) ? (Block)FloocraftBase.MAGENTA_FLAMES_BUSY.get() : (Block)FloocraftBase.GREEN_FLAMES_BUSY.get();
                    worldIn.func_180501_a(pos, (BlockState)fireBlock.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(this.concentration)), 3);
                    worldIn.func_184133_a(null, pos, (SoundEvent)FloocraftBase.GREENED.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                context.func_195996_i().func_190917_f(-1);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (!world.field_72995_K) {
            Vector3d pos = location.func_213303_ch();
            DroppedFlooPowderEntity flp = new DroppedFlooPowderEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, itemstack, this.concentration);
            flp.func_174867_a(40);
            flp.func_213317_d(location.func_213322_ci());
            return flp;
        }
        return null;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.concentration == 9) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.concentration", (Object[])new Object[]{Character.valueOf('\u221e')})).func_240699_a_(TextFormatting.GREEN));
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.creativeonly", (Object[])new Object[0])));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.concentration", (Object[])new Object[]{this.concentration})).func_240699_a_(TextFormatting.GREEN));
            if (this.concentration == 1) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.craftable", (Object[])new Object[0])));
            }
        }
    }
}

