/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.FlooFlamesBase;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class FloocraftWorldData
extends WorldSavedData {
    public final ConcurrentHashMap<String, int[]> placeList = new ConcurrentHashMap();

    public FloocraftWorldData() {
        super("floocraftft");
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT ListNBT2 = nbt.func_150295_c("floocraftft", 10);
        for (int i = 0; i < ListNBT2.size(); ++i) {
            CompoundNBT nbt1 = ListNBT2.func_150305_b(i);
            int[] coords = new int[]{nbt1.func_74762_e("X"), nbt1.func_74762_e("Y"), nbt1.func_74762_e("Z")};
            this.placeList.put(nbt1.func_74779_i("NAME"), coords);
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        ListNBT ListNBT2 = new ListNBT();
        for (String nextName : this.placeList.keySet()) {
            CompoundNBT nbt1 = new CompoundNBT();
            nbt1.func_74778_a("NAME", nextName);
            int[] coords = this.placeList.get(nextName);
            nbt1.func_74768_a("X", coords[0]);
            nbt1.func_74768_a("Y", coords[1]);
            nbt1.func_74768_a("Z", coords[2]);
            ListNBT2.add((Object)nbt1);
        }
        compound.func_218657_a("floocraftft", (INBT)ListNBT2);
        return compound;
    }

    public static FloocraftWorldData forWorld(World world) {
        ServerWorld serverWorld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        DimensionSavedDataManager storage = serverWorld.func_217481_x();
        return (FloocraftWorldData)storage.func_215752_a(FloocraftWorldData::new, "floocraftft");
    }

    public void addLocation(String name, BlockPos pos) {
        this.placeList.put(name, new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        FloocraftBase.info("[FLOOCRAFT-SERVER] Added fireplace at " + pos.toString() + ". Name: " + name);
        this.func_76185_a();
    }

    public void removeLocation(int x, int y, int z) {
        int[] coords = new int[]{x, y, z};
        boolean removedPlace = false;
        Iterator i = ((ConcurrentHashMap.KeySetView)this.placeList.keySet()).iterator();
        while (i.hasNext() && !removedPlace) {
            String nextPlaceName = (String)i.next();
            if (!Arrays.equals(this.placeList.get(nextPlaceName), coords)) continue;
            FloocraftBase.info("[FLOOCRAFT-SERVER] Removed fireplace at (" + x + ", " + y + ", " + z + "). Name: " + nextPlaceName);
            this.placeList.remove(nextPlaceName);
            removedPlace = true;
        }
        if (!removedPlace) {
            FloocraftBase.warn("[FLOOCRAFT-SERVER] Failed to remove fireplace at (" + x + ", " + y + ", " + z + ").");
            FloocraftBase.warn("[FLOOCRAFT-SERVER] Data can be manually removed with an NBT editor.");
        }
        this.func_76185_a();
    }

    public MessageFireplaceList assembleNewFireplaceList(World w) {
        MessageFireplaceList m = new MessageFireplaceList();
        m.places = ((ConcurrentHashMap.CollectionView)((Object)this.placeList.keySet())).toArray();
        boolean[] l = new boolean[m.places.length];
        int keyCount = 0;
        FlooFlamesBase greenTemp = (FlooFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP.get();
        for (String nextName : this.placeList.keySet()) {
            int[] coords = this.placeList.get(nextName);
            BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
            Block b = w.func_180495_p(dest).func_177230_c();
            boolean ok = b.func_203417_a((ITag)BlockTags.field_232872_am_) ? greenTemp.isInFireplace(w, dest) != null : b instanceof FlooFlamesBase;
            l[keyCount] = ok;
            ++keyCount;
        }
        m.enabledList = l;
        return m;
    }
}

