/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.FloocraftBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageFlooTorchTeleport {
    public int torchX;
    public int torchY;
    public int torchZ;

    private static boolean isAdjacent(BlockPos pos1, BlockPos pos2) {
        int xDiff = Math.abs(pos1.func_177958_n() - pos2.func_177958_n());
        int zDiff = Math.abs(pos1.func_177952_p() - pos2.func_177952_p());
        return xDiff == 0 && zDiff == 1 || xDiff == 1 && zDiff == 0;
    }

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int torchX1 = this.torchX;
            int torchY1 = this.torchY;
            int torchZ1 = this.torchZ;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerWorld world = player.func_71121_q();
            int minx = torchX1 - 3;
            int maxx = torchX1 + 3;
            int minz = torchZ1 - 3;
            int maxz = torchZ1 + 3;
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            ArrayList<BlockPos> torchCoords = new ArrayList<BlockPos>();
            Block flooTorchBlock = (Block)FloocraftBase.BLOCK_FLOO_TORCH.get();
            for (int x = minx; x <= maxx; ++x) {
                for (int z = minz; z <= maxz; ++z) {
                    BlockPos nextPos;
                    if (x == torchX1 || z == torchZ1 || !world.func_175623_d((nextPos = new BlockPos(x, torchY1, z)).func_177984_a())) continue;
                    if (world.func_175623_d(nextPos)) {
                        coords.add(nextPos);
                        continue;
                    }
                    if (world.func_180495_p(nextPos).func_177230_c() != flooTorchBlock) continue;
                    torchCoords.add(nextPos);
                }
            }
            ArrayList<BlockPos> finalCoords = new ArrayList<BlockPos>();
            if (torchCoords.isEmpty()) {
                finalCoords = coords;
            } else {
                for (BlockPos torchPos : torchCoords) {
                    for (BlockPos emptyPos : coords) {
                        if (!MessageFlooTorchTeleport.isAdjacent(torchPos, emptyPos)) continue;
                        finalCoords.add(emptyPos);
                    }
                }
                if (finalCoords.isEmpty()) {
                    finalCoords = coords;
                }
            }
            if (finalCoords.size() > 0) {
                BlockPos chosenCoord = (BlockPos)finalCoords.get(world.field_73012_v.nextInt(finalCoords.size()));
                double x = (double)chosenCoord.func_177958_n() + 0.5;
                double y = chosenCoord.func_177956_o();
                double z = (double)chosenCoord.func_177952_p() + 0.5;
                if (player.func_184187_bx() != null) {
                    player.func_184210_p();
                }
                player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
                player.field_70143_R = 0.0f;
                world.func_184133_a(null, new BlockPos(torchX1, torchY1, torchZ1), (SoundEvent)FloocraftBase.FLICK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public MessageFlooTorchTeleport() {
    }

    public MessageFlooTorchTeleport(ByteBuf buf) {
        this.torchX = buf.readInt();
        this.torchY = buf.readInt();
        this.torchZ = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.torchX);
        buf.writeInt(this.torchY);
        buf.writeInt(this.torchZ);
    }
}

