/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.FlooFlamesBase;
import com.fredtargaryen.floocraft.config.CommonConfig;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageDoGreenFlash;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageTeleportEntity {
    public int initX;
    public int initY;
    public int initZ;
    public String dest;
    private static final Charset defaultCharset = Charset.defaultCharset();

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            boolean validDest = false;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            int[] destCoords = FloocraftWorldData.forWorld((World)world).placeList.get(this.dest);
            if (destCoords[0] != this.initX || destCoords[1] != this.initY || destCoords[2] != this.initZ) {
                BlockPos destBlockPos = new BlockPos(destCoords[0], destCoords[1], destCoords[2]);
                Block destBlock = world.func_180495_p(destBlockPos).func_177230_c();
                ITagCollection blockTags = BlockTags.func_199896_a();
                ITag arrivalBlocks = blockTags.func_199910_a(DataReference.VALID_ARRIVAL_BLOCKS);
                ITag departureBlocks = blockTags.func_199910_a(DataReference.VALID_DEPARTURE_BLOCKS);
                FlooFlamesBase greenTemp = (FlooFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP.get();
                if (destBlock.func_203417_a(arrivalBlocks)) {
                    validDest = greenTemp.isInFireplace(world, destBlockPos) != null;
                }
                BlockPos initBlockPos = new BlockPos(this.initX, this.initY, this.initZ);
                BlockState initBlockState = world.func_180495_p(initBlockPos);
                Block initBlock = initBlockState.func_177230_c();
                if (validDest && initBlock.func_203417_a(departureBlocks)) {
                    boolean initSoul = initBlock == FloocraftBase.FLOO_CAMPFIRE.get() ? false : (initBlock == FloocraftBase.FLOO_SOUL_CAMPFIRE.get() ? true : SoulFireBlock.func_235577_c_((Block)world.func_180495_p(initBlockPos.func_177977_b()).func_177230_c()));
                    boolean destSoul = SoulFireBlock.func_235577_c_((Block)world.func_180495_p(destBlockPos.func_177977_b()).func_177230_c());
                    if (!destBlock.func_203417_a(departureBlocks)) {
                        world.func_175656_a(destBlockPos, destSoul ? ((Block)FloocraftBase.MAGENTA_FLAMES_TEMP.get()).func_176223_P() : greenTemp.func_176223_P());
                    }
                    MessageHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageDoGreenFlash(initSoul));
                    if (player.func_184187_bx() != null) {
                        player.func_184210_p();
                    }
                    player.field_71135_a.func_147364_a((double)destCoords[0] + 0.5, (double)destCoords[1], (double)destCoords[2] + 0.5, player.func_70681_au().nextFloat() * 360.0f, player.field_70125_A);
                    player.field_70143_R = 0.0f;
                    if (((Boolean)CommonConfig.DEPLETE_FLOO.get()).booleanValue()) {
                        int m = (Integer)initBlockState.func_177229_b((Property)BlockStateProperties.field_208171_X);
                        if (m < 2) {
                            if (initBlock == FloocraftBase.FLOO_CAMPFIRE.get()) {
                                world.func_175656_a(initBlockPos, (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, initBlockState.func_177229_b((Property)BlockStateProperties.field_208157_J)));
                            } else if (initBlock == FloocraftBase.FLOO_SOUL_CAMPFIRE.get()) {
                                world.func_175656_a(initBlockPos, (BlockState)Blocks.field_235367_mf_.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, initBlockState.func_177229_b((Property)BlockStateProperties.field_208157_J)));
                            } else {
                                world.func_175656_a(initBlockPos, initSoul ? Blocks.field_235335_bO_.func_176223_P() : Blocks.field_150480_ab.func_176223_P());
                            }
                        } else {
                            world.func_180501_a(initBlockPos, (BlockState)initBlockState.func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(m == 9 ? 9 : m - 1)), 2);
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public MessageTeleportEntity() {
    }

    public MessageTeleportEntity(ByteBuf buf) {
        this.initX = buf.readInt();
        this.initY = buf.readInt();
        this.initZ = buf.readInt();
        this.dest = buf.readBytes(buf.readInt()).toString(defaultCharset);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.initX);
        buf.writeInt(this.initY);
        buf.writeInt(this.initZ);
        buf.writeInt(this.dest.length());
        buf.writeBytes(this.dest.getBytes());
    }
}

