/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.tileentity;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.FlooFlamesBase;
import com.fredtargaryen.floocraft.block.FlooSignBlock;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FireplaceTileEntity
extends TileEntity {
    public final String[] signText = new String[]{"", "", "", ""};
    private int lineBeingEdited = -1;
    private PlayerEntity writer;
    private boolean isConnected;
    private int y;

    public FireplaceTileEntity() {
        super((TileEntityType)FloocraftBase.FIREPLACE_TYPE.get());
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT par1) {
        par1 = super.func_189515_b(par1);
        par1.func_74757_a("Connected", this.isConnected);
        par1.func_74768_a("Y", this.y);
        for (int i = 0; i < 4; ++i) {
            par1.func_74778_a(String.valueOf(i), this.getString(i));
        }
        return par1;
    }

    public void func_230337_a_(BlockState state, CompoundNBT par1) {
        super.func_230337_a_(state, par1);
        this.isConnected = par1.func_74767_n("Connected");
        this.y = par1.func_74762_e("Y");
        for (int i = 0; i < 4; ++i) {
            this.setString(i, par1.func_74779_i(String.valueOf(i)));
        }
    }

    public static String getSignTextAsLine(String[] signText) {
        return signText[0] + " " + signText[1] + " " + signText[2] + " " + signText[3];
    }

    public String getString(int index) {
        return this.signText[index];
    }

    public void setString(int index, String s) {
        this.signText[index] = s;
    }

    @Nonnull
    public PlayerEntity getPlayer() {
        return this.writer;
    }

    public void setPlayer(@Nonnull PlayerEntity par1PlayerEntity) {
        if (this.writer == null) {
            this.writer = par1PlayerEntity;
        }
    }

    public int getLineBeingEdited() {
        return this.lineBeingEdited;
    }

    public void setLineBeingEdited(int index) {
        this.lineBeingEdited = index;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public void addLocation() {
        if (!this.field_145850_b.field_72995_K) {
            BlockPos locationPos = FireplaceTileEntity.iterateDownFromSign(this.field_145850_b, this.field_174879_c);
            this.y = locationPos.func_177956_o();
            FloocraftWorldData.forWorld(this.field_145850_b).addLocation(FireplaceTileEntity.getSignTextAsLine(this.signText), locationPos);
            this.func_70296_d();
        }
    }

    private static BlockPos iterateDownFromSign(World w, BlockPos pos) {
        pos = pos.func_177972_a(((Direction)w.func_180495_p(pos).func_177229_b((Property)FlooSignBlock.field_176412_a)).func_176734_d()).func_177967_a(Direction.DOWN, 1);
        while ((w.func_175623_d(pos) || w.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_232872_am_) || w.func_180495_p(pos).func_177230_c() instanceof FlooFlamesBase) && pos.func_177956_o() > -1) {
            pos = pos.func_177967_a(Direction.DOWN, 1);
        }
        return pos.func_177967_a(Direction.UP, 1);
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean getConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean b) {
        this.isConnected = b;
        this.func_70296_d();
    }
}

