/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.tileentity;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.inventory.container.FloowerPotContainer;
import com.fredtargaryen.floocraft.item.ItemFlooPowder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FloowerPotTileEntity
extends TileEntity
implements IInventory,
INamedContainerProvider {
    public boolean justUpdated;
    private final ItemStack[] inv = new ItemStack[1];
    private int hRange;
    private int vRange;

    public FloowerPotTileEntity() {
        super((TileEntityType)FloocraftBase.POT_TYPE.get());
        this.inv[0] = ItemStack.field_190927_a;
        this.hRange = 5;
        this.vRange = 5;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public boolean func_191420_l() {
        return this.inv[0].func_190926_b();
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() <= amt) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((stack = stack.func_77979_a(amt)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @ParametersAreNonnullByDefault
    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack nonnullstack;
        this.inv[slot] = nonnullstack = stack == null ? ItemStack.field_190927_a : stack;
        if (!nonnullstack.func_190926_b() && nonnullstack.func_190916_E() > this.func_70297_j_()) {
            nonnullstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    @ParametersAreNonnullByDefault
    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    @ParametersAreNonnullByDefault
    public void func_174889_b(PlayerEntity player) {
    }

    @ParametersAreNonnullByDefault
    public void func_174886_c(PlayerEntity player) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFlooPowder;
    }

    public void func_174888_l() {
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        ListNBT tagList = tagCompound.func_150295_c("Inventory", 10);
        if (tagList.size() == 0) {
            this.inv[0] = ItemStack.field_190927_a;
        } else {
            CompoundNBT tag = tagList.func_150305_b(0);
            byte slot = tag.func_74771_c("Slot");
            if (slot == 0) {
                this.inv[slot] = ItemStack.func_199557_a((CompoundNBT)tag);
            }
        }
        this.hRange = Math.max(2, Math.min(5, tagCompound.func_74762_e("hRange")));
        this.vRange = Math.max(2, Math.min(5, tagCompound.func_74762_e("vRange")));
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        ListNBT itemList = new ListNBT();
        ItemStack stack = this.inv[0];
        if (stack != null && !stack.func_190926_b()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Slot", (byte)0);
            stack.func_77955_b(tag);
            itemList.add((Object)tag);
        }
        tagCompound.func_218657_a("Inventory", (INBT)itemList);
        tagCompound.func_74768_a("hRange", this.hRange);
        tagCompound.func_74768_a("vRange", this.vRange);
        return tagCompound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
        this.justUpdated = true;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.floocraftft.floowerpot");
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new FloowerPotContainer(windowId, inventory, player.field_70170_p, this.field_174879_c);
    }

    public void adjustPotRange(char range, int amount) {
        if (range == 'h') {
            if (amount == 1 && this.hRange < 5) {
                ++this.hRange;
            } else if (amount == -1 && this.hRange > 2) {
                --this.hRange;
            }
            this.func_70296_d();
        } else if (range == 'v') {
            if (amount == 1 && this.vRange < 5) {
                ++this.vRange;
            } else if (amount == -1 && this.vRange > 2) {
                --this.vRange;
            }
            this.func_70296_d();
        }
    }

    public int getHRange() {
        return this.hRange;
    }

    public int getVRange() {
        return this.vRange;
    }
}

