/*
 * Decompiled with CFR 0.152.
 */
package com.theishiopian.foragecraft;

import com.theishiopian.foragecraft.ForageLogger;
import com.theishiopian.foragecraft.SeedLoader;
import com.theishiopian.foragecraft.config.ConfigHandler;
import com.theishiopian.foragecraft.handler.BlockForageHandler;
import com.theishiopian.foragecraft.handler.EventHandler;
import com.theishiopian.foragecraft.handler.FuelHandler;
import com.theishiopian.foragecraft.handler.PotatoPlanter;
import com.theishiopian.foragecraft.handler.RecipeHandler;
import com.theishiopian.foragecraft.handler.SpawnHandler;
import com.theishiopian.foragecraft.init.ModBlocks;
import com.theishiopian.foragecraft.init.ModEntities;
import com.theishiopian.foragecraft.init.ModItems;
import com.theishiopian.foragecraft.proxy.CommonProxy;
import com.theishiopian.foragecraft.world.generation.FCMasterWorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="foragecraft", name="ForageCraft", version="1.14.2", acceptedMinecraftVersions="[1.12], [1.12.1], [1.12.2]", updateJSON="https://raw.githubusercontent.com/theishiopian/ForageCraft/master/update.json")
public class ForageCraftMod {
    public static final String MODID = "foragecraft";
    public static final String MOD_NAME = "ForageCraft";
    public static final String NAME = "ForageCraft";
    public static final String VERSION = "1.14.2";
    public static final String MC_VERSIONS = "[1.12], [1.12.1], [1.12.2]";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/theishiopian/ForageCraft/master/update.json";
    public static final String PROXY_CLIENT = "com.theishiopian.foragecraft.proxy.Client";
    public static final String PROXY_SERVER = "com.theishiopian.foragecraft.proxy.Server";
    @SidedProxy(clientSide="com.theishiopian.foragecraft.proxy.Client", serverSide="com.theishiopian.foragecraft.proxy.Server")
    public static CommonProxy proxy;
    @Mod.Instance
    public static ForageCraftMod instance;
    public static EventHandler forgeEventHandler;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        ConfigHandler.loadConfig(event);
        ConfigHandler.autoDeveloperMode("dev");
        ConfigHandler.configWarnings();
        forgeEventHandler = new EventHandler();
        forgeEventHandler.register();
        ForageLogger.printInfo("Target acquired...");
        ModBlocks.init();
        ForageLogger.printDevelop("Blocks initialized successfully.");
        ModItems.init();
        ForageLogger.printDevelop("Items initialized successfully.");
        ModEntities.init();
        ForageLogger.printDevelop("Entities initialized successfully.");
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        proxy.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new PotatoPlanter());
        MinecraftForge.EVENT_BUS.register((Object)new BlockForageHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpawnHandler());
        RecipeHandler.Shapless();
        SeedLoader.seed();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new FCMasterWorldGenerator(), (int)10);
        ForageLogger.printInfo("The Magic School Bus is here.");
    }
}

