/*
 * Decompiled with CFR 0.152.
 */
package com.theishiopian.foragecraft.config;

import com.theishiopian.foragecraft.ForageLogger;
import com.theishiopian.foragecraft.config.ConfigVariables;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static void loadConfig(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ConfigVariables.branchChance = config.getFloat("Branch chance", "Sticks from leaves", 1.0f, 0.0f, 1.0f, "The chance of a stick dropping fom leaves");
        ConfigVariables.branchMaxAmount = config.getInt("Maximum branch amount", "Sticks from leaves", 1, 0, 64, "The maximum number of sticks you can get from leaves");
        ConfigVariables.rootChance = config.getFloat("Root chance", "Sticks from grass blocks", 0.09f, 0.0f, 1.0f, "The chance of digging up a root (stick) from a grass block");
        ConfigVariables.rootMaxAmount = config.getInt("Maximum root amount", "Sticks from grass blocks", 1, 0, 64, "The maximum amount of roots (sticks) you can get from a grass block");
        ConfigVariables.rockChance = config.getFloat("Rock chance", "Rocks from various blocks", 0.09f, 0.0f, 1.0f, "The chance of digging up a rock");
        ConfigVariables.rockMaxAmount = config.getInt("Maximum rock amount", "Rocks from various blocks", 1, 0, 64, "The maximum amount of rocks you can get from various blocks");
        ConfigVariables.wildCarrotChance = config.getFloat("Carrot chance", "Carrots from grass blocks", 0.01f, 0.0f, 1.0f, "The chance of digging up a carrot from a grass block");
        ConfigVariables.wildCarrotMaxAmount = config.getInt("Maximum carrot amount", "Carrots from grass blocks", 1, 0, 64, "The maximum amount of carrots you can get from a grass block");
        ConfigVariables.wildPotatoChance = config.getFloat("Potato chance", "Potatoes from grass blocks", 0.01f, 0.0f, 1.0f, "The chance of digging up a potato from a grass block");
        ConfigVariables.wildPotatoMaxAmount = config.getInt("Maximum potato amount", "Potatoes from grass blocks", 1, 0, 64, "The maximum amount of potatoes you can get from a grass block");
        ConfigVariables.wildToxicPotatoChance = config.getFloat("Poisonous potato chance", "Potatoes from grass blocks", 0.01f, 0.0f, 1.0f, "The chance of digging up a poisonous potato from a grass block");
        ConfigVariables.wildToxicPotatoMaxAmount = config.getInt("Maximum poisonous potato amount", "Potatoes from grass blocks", 1, 0, 64, "The maximum amount of poisonous potatoes you can get from a grass block");
        ConfigVariables.wildBeetRootChance = config.getFloat("Beet root chance", "Beet roots from grass blocks", 0.01f, 0.0f, 1.0f, "The chance of digging up a beet root from a grass block");
        ConfigVariables.wildBeetRootMaxAmount = config.getInt("Maximum beet root amount", "Beet roots from grass blocks", 1, 0, 64, "The maximum amount of beet root you can get from a grass block");
        ConfigVariables.buriedBonesChance = config.getFloat("Buried bones chance", "Buried Bones", 0.005f, 0.0f, 1.0f, "The chance of uncovering ancient bones");
        ConfigVariables.buriedBonesMaxBoneAmount = config.getInt("Maximum buried bones amount", "Buried Bones", 9, 0, 64, "The maximum amount of bones you can get from buried skeletons");
        ConfigVariables.buriedBonesMaxSkullAmount = config.getInt("Maximum buried skull amount", "Buried Bones", 1, 0, 64, "The maximum amount of skulls buried skeletons can have");
        ConfigVariables.deepRootChance = config.getFloat("Deep root chance", "Sticks from dirt blocks", 0.07f, 0.0f, 1.0f, "The chance of digging up a root (stick) from a dirt block");
        ConfigVariables.deepRootMaxAmount = config.getInt("Maximum deep root amount", "Sticks from dirt blocks", 1, 0, 64, "The maximum amount of roots (sticks) you can get from a dirt block");
        ConfigVariables.buriedFlintChance = config.getFloat("Buried Flint Chance", "Buried Flint", 0.04f, 0.0f, 1.0f, "The chance of finding flint in a dirt block");
        ConfigVariables.buriedFlintMaxAmount = config.getInt("Maximum buried flint amount", "Buried Flint", 1, 0, 64, "The maximum amount of flint you can get from a dirt block");
        ConfigVariables.goldChance = config.getFloat("Gold chance", "Gold in stone", 0.005f, 0.0f, 1.0f, "The chance of finding gold (in nugget form) inside a stone block");
        ConfigVariables.goldMaxAmount = config.getInt("Maximum gold amount", "Gold in stone", 1, 0, 64, "The maximum amount of gold nuggets you can find in a stone block");
        ConfigVariables.flintChipChance = config.getFloat("Flint chip chance", "Flint chips", 0.05f, 0.0f, 1.0f, "The chance of finding flint in a stone block");
        ConfigVariables.flintChipMaxAmount = config.getInt("Maximum flint chip amount", "Flint chips", 1, 0, 64, "The maximum amount of flint you can get from a stone block");
        ConfigVariables.coalDiamondChance = config.getFloat("Coal diamond chance", "Coal gems", 0.001f, 0.0f, 1.0f, "The chance of finding a diamond while mining coal");
        ConfigVariables.coalDiamondMaxAmount = config.getInt("Maximum coal diamond amount", "Coal gems", 1, 0, 64, "The maximum amount of diamonds you can get from coal ore");
        ConfigVariables.coalEmeraldChance = config.getFloat("Coal emerald chance", "Coal gems", 0.001f, 0.0f, 1.0f, "The chance of finding an emerald while mining coal");
        ConfigVariables.coalEmeraldMaxAmount = config.getInt("Maximum coal emerald amount", "Coal gems", 1, 0, 64, "The maximum amount of emeralds you can get from coal ore");
        ConfigVariables.netherGoldChance = config.getFloat("Nether gold chance", "Nether gold", 1.0f, 0.0f, 1.0f, "The chance of getting a gold nugget from nether quartz");
        ConfigVariables.netherGoldMaxAmount = config.getInt("Maximum nether gold amount", "Nether gold", 9, 0, 64, "The maximum amount of gold nuggets you can get from nether quartz");
        ConfigVariables.pumpkinSeeds = config.getBoolean("Pumpkin seeds from grass", "Pumpkin seeds", true, "This determines whether or not you can find pumpkin seeds in grass");
        ConfigVariables.melonSeeds = config.getBoolean("Melon seeds from grass", "Melon seeds", true, "This determines whether or not you can find melon seeds in grass");
        ConfigVariables.beetrootSeeds = config.getBoolean("Beetroot seeds from grass", "Beetroot seeds", true, "This determines whether or not you can find beetroot seeds in grass");
        ConfigVariables.developerMode = config.getBoolean("Developer Mode", "development", false, "Developer mode logs world generation of sticks and rocks to the console");
        ConfigVariables.jeiVanillaInt = config.getBoolean("JEI Integration", "Mod Integration", true, "This determines whether or not JEI Integration should be enabled for vanilla items");
        ConfigVariables.enableSticks = config.getBoolean("Sticks generation", "World Generation", true, "This determines whether or not sticks should be generated");
        ConfigVariables.enableRocks = config.getBoolean("Rocks generation", "World Generation", true, "This determines whether or not rocks should be generated");
        config.save();
        ConfigHandler.debugListAllVariables();
        ForageLogger.printInfo("Configuration file loaded.");
    }

    public static void autoDeveloperMode(String versionCode) {
        if ("1.14.2".contains(versionCode)) {
            ConfigVariables.developerMode = true;
            ForageLogger.printInfo("This is a development version of ForageCraft. Therefore, developer mode has been automatically enabled.");
        }
    }

    public static void configWarnings() {
        if (ConfigVariables.developerMode) {
            ForageLogger.printWarn("Developer Mode is enabled. Development logging will occur at the [INFO] level. Generation of rocks and sticks will always occur at [DEBUG] level.");
        }
        if (!ConfigVariables.jeiVanillaInt) {
            ForageLogger.printWarn("JEI Integration for vanilla items has been disabled.");
        }
        if (!ConfigVariables.enableSticks) {
            ForageLogger.printWarn("Stick generation has been disabled in the ForageCraft configuration file.");
        }
        if (!ConfigVariables.enableRocks) {
            ForageLogger.printWarn("Rock generation has been disabled in the ForageCraft configuration file.");
        }
    }

    public static void debugListAllVariables() {
        ForageLogger.printDebug("Chance of digging up sticks from leaves is " + ConfigVariables.branchChance);
        ForageLogger.printDebug("Maximum amount of sticks dropping from leaves is " + ConfigVariables.branchMaxAmount);
        ForageLogger.printDebug("Chance of digging up sticks from grass block is " + ConfigVariables.rootChance);
        ForageLogger.printDebug("Maximum amount of sticks dropping from grass block is " + ConfigVariables.rootMaxAmount);
        ForageLogger.printDebug("Chance of digging up sticks from dirt is " + ConfigVariables.deepRootChance);
        ForageLogger.printDebug("Maximum amount of sticks dropping from dirt is " + ConfigVariables.deepRootMaxAmount);
        ForageLogger.printDebug("Chance of digging up rocks from various blocks is " + ConfigVariables.rockChance);
        ForageLogger.printDebug("Maximum amount of rocks dropping from various blocks is " + ConfigVariables.rockMaxAmount);
        ForageLogger.printDebug("Chance of digging up carrots from a grass block is " + ConfigVariables.wildCarrotChance);
        ForageLogger.printDebug("Maximum amount of carrots dropping from a grass block is " + ConfigVariables.wildCarrotMaxAmount);
        ForageLogger.printDebug("Chance of digging up potatoes from a grass block is " + ConfigVariables.wildPotatoChance);
        ForageLogger.printDebug("Maximum amount of potatoes dropping from a grass block is " + ConfigVariables.wildPotatoMaxAmount);
        ForageLogger.printDebug("Chance of digging up beet root from a grass block is " + ConfigVariables.wildBeetRootChance);
        ForageLogger.printDebug("Maximum amount of beet root dropping from a grass block is " + ConfigVariables.wildBeetRootMaxAmount);
        if (ConfigVariables.beetrootSeeds) {
            ForageLogger.printDebug("Digging up beet root seeds from grass is enabled.");
        } else {
            ForageLogger.printDebug("Digging up beet root seeds from grass is disabled.");
        }
        if (ConfigVariables.pumpkinSeeds) {
            ForageLogger.printDebug("Digging up pumpkin seeds from grass is enabled.");
        } else {
            ForageLogger.printDebug("Digging up pumpkin seeds from grass is disabled.");
        }
        if (ConfigVariables.melonSeeds) {
            ForageLogger.printDebug("Digging up melon seeds from grass is enabled.");
        } else {
            ForageLogger.printDebug("Digging up melon seeds from grass is disabled.");
        }
        ForageLogger.printDebug("Chance of digging up bones is " + ConfigVariables.buriedBonesChance);
        ForageLogger.printDebug("Maximum amount of bones dropping from stone is " + ConfigVariables.buriedBonesMaxBoneAmount);
        ForageLogger.printDebug("Maximum amount of skulls dropping from stone is " + ConfigVariables.buriedBonesMaxSkullAmount);
        ForageLogger.printDebug("Chance of digging up flint from dirt is " + ConfigVariables.buriedFlintChance);
        ForageLogger.printDebug("Maximum amount of flint dropping from dirt is " + ConfigVariables.buriedFlintMaxAmount);
        ForageLogger.printDebug("Chance of digging up flint from stone is " + ConfigVariables.flintChipChance);
        ForageLogger.printDebug("Maximum amount of flint dropping from stone is " + ConfigVariables.flintChipMaxAmount);
        ForageLogger.printDebug("Chance of digging up gold nuggets from stone is " + ConfigVariables.goldChance);
        ForageLogger.printDebug("Maximum amount of gold nuggets dropping from stone is " + ConfigVariables.goldMaxAmount);
        ForageLogger.printDebug("Chance of digging up gold nuggets from nether quartz ore is " + ConfigVariables.netherGoldChance);
        ForageLogger.printDebug("Maximum amount of gold nuggets dropping from nether quartz ore is " + ConfigVariables.netherGoldMaxAmount);
        ForageLogger.printDebug("Chance of digging up diamonds from coal ore is " + ConfigVariables.coalDiamondChance);
        ForageLogger.printDebug("Maximum amount of diamonds dropping from coal ore is " + ConfigVariables.coalDiamondMaxAmount);
        ForageLogger.printDebug("Chance of digging up emeralds from coal ore is " + ConfigVariables.coalEmeraldChance);
        ForageLogger.printDebug("Maximum amount of emeralds dropping from coal ore is " + ConfigVariables.coalEmeraldMaxAmount);
    }
}

