/*
 * Decompiled with CFR 0.152.
 */
package com.theishiopian.foragecraft.items;

import com.theishiopian.foragecraft.entity.EntityRockFlat;
import com.theishiopian.foragecraft.entity.EntityRockNormal;
import com.theishiopian.foragecraft.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RockItem
extends ItemBlock {
    ModBlocks.RockType type;

    public RockItem(Block block, ModBlocks.RockType t) {
        super(block);
        String name = null;
        switch (t) {
            case NORMAL: {
                name = "rock_normal";
                break;
            }
            case FLAT: {
                name = "rock_flat";
            }
        }
        this.type = t;
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ModBlocks.RockType getRockType() {
        return this.type;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        switch (this.type) {
            case FLAT: {
                target.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case NORMAL: {
                target.func_70097_a(DamageSource.field_76377_j, 3.0f);
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EntityThrowable rock = new EntityRockNormal(worldIn, (EntityLivingBase)playerIn);
            switch (this.type) {
                case NORMAL: {
                    rock = new EntityRockNormal(worldIn, (EntityLivingBase)playerIn);
                    break;
                }
                case FLAT: {
                    rock = new EntityRockFlat(worldIn, (EntityLivingBase)playerIn);
                    break;
                }
            }
            rock.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_72838_d((Entity)rock);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }
}

