/*
 * Decompiled with CFR 0.152.
 */
package com.theishiopian.foragecraft.world;

import com.theishiopian.foragecraft.ForageLogger;
import java.util.LinkedHashSet;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class ScarecrowTracking
extends WorldSavedData {
    private final LinkedHashSet<BlockPos> scarecrowLocations = new LinkedHashSet();
    private static final String NAME = "foragecraft:scarecrows";

    public ScarecrowTracking() {
        super(NAME);
    }

    public static ScarecrowTracking get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        ScarecrowTracking instance = (ScarecrowTracking)storage.func_75742_a(ScarecrowTracking.class, NAME);
        if (instance == null) {
            instance = new ScarecrowTracking();
            storage.func_75745_a(NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public void addScarecrow(BlockPos pos) {
        this.scarecrowLocations.add(pos);
        ForageLogger.printDevelop("Registering Scarecrow");
    }

    public void removeScarecrow(BlockPos pos) {
        this.scarecrowLocations.remove(pos);
        ForageLogger.printDevelop("Unregistering Scarecrow");
    }

    public void func_76184_a(NBTTagCompound scTag) {
        this.scarecrowLocations.clear();
        NBTTagList scarecrows = scTag.func_150295_c("Scarecrows", 10);
        for (int i = 0; i < scarecrows.func_74745_c(); ++i) {
            NBTTagCompound locationTag = scarecrows.func_150305_b(i);
            BlockPos location = new BlockPos(locationTag.func_74762_e("posX"), locationTag.func_74762_e("posY"), locationTag.func_74762_e("posZ"));
            this.scarecrowLocations.add(location);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound scTag) {
        NBTTagList locationList = new NBTTagList();
        for (BlockPos pos : this.scarecrowLocations) {
            NBTTagCompound locationTag = new NBTTagCompound();
            locationTag.func_74768_a("posX", pos.func_177958_n());
            locationTag.func_74768_a("posY", pos.func_177956_o());
            locationTag.func_74768_a("posZ", pos.func_177952_p());
            locationList.func_74742_a((NBTBase)locationTag);
        }
        scTag.func_74782_a("Scarecrows", (NBTBase)locationList);
        return scTag;
    }

    public boolean inRange(Entity entity) {
        for (BlockPos pos : this.scarecrowLocations) {
            if (!entity.func_174813_aQ().func_72326_a(new AxisAlignedBB(pos).func_72321_a(64.0, 64.0, 64.0))) continue;
            return true;
        }
        return false;
    }
}

