/*
 * Decompiled with CFR 0.152.
 */
package com.theishiopian.foragecraft.world.generation;

import com.theishiopian.foragecraft.config.ConfigVariables;
import com.theishiopian.foragecraft.world.generation.RockGenerator;
import com.theishiopian.foragecraft.world.generation.StickGenerator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FCMasterWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, random, blockX, blockZ);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, blockX, blockZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, blockX, blockZ);
            }
        }
    }

    private void generateNether(World world, Random rand, int blockX, int blockZ) {
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        int randZ;
        int randY;
        int randX;
        int i;
        RockGenerator rocky = new RockGenerator();
        StickGenerator sticky = new StickGenerator();
        int MIN = 32;
        int MAX = 1024;
        int rockRange = MIN + rand.nextInt(MAX - MIN);
        int stickRange = MIN + rand.nextInt(MAX - MIN);
        BlockPos biomeCheckPos = new BlockPos(blockX, 64, blockZ);
        if (ConfigVariables.enableRocks) {
            for (i = 0; i < rockRange; ++i) {
                randX = blockX + rand.nextInt(16) + 8;
                randY = rand.nextInt(255);
                randZ = blockZ + rand.nextInt(16) + 8;
                BlockPos pos = new BlockPos(randX, randY, randZ);
                rocky.func_180709_b(world, rand, pos);
            }
        }
        if ((BiomeDictionary.hasType((Biome)world.func_180494_b(biomeCheckPos), (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)world.func_180494_b(biomeCheckPos), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.hasType((Biome)world.func_180494_b(biomeCheckPos), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) && ConfigVariables.enableSticks) {
            for (i = 0; i < stickRange; ++i) {
                randX = blockX + rand.nextInt(16) + 8;
                randY = rand.nextInt(255);
                randZ = blockZ + rand.nextInt(16) + 8;
                sticky.func_180709_b(world, rand, new BlockPos(randX, randY, randZ));
            }
        }
    }

    private void generateEnd(World world, Random rand, int blockX, int blockZ) {
    }
}

