/*
 * Decompiled with CFR 0.152.
 */
package me.jonathing.minecraft.foragecraft;

import me.jonathing.minecraft.foragecraft.client.ForageClient;
import me.jonathing.minecraft.foragecraft.common.registry.ForageFeatures;
import me.jonathing.minecraft.foragecraft.common.registry.ForageRegistry;
import me.jonathing.minecraft.foragecraft.common.security.VerificationUtil;
import me.jonathing.minecraft.foragecraft.data.ForageCraftDataGen;
import me.jonathing.minecraft.foragecraft.info.ForageInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="foragecraft")
public class ForageCraft {
    public static final Logger LOGGER = LogManager.getLogger((String)"ForageCraft");

    public ForageCraft() {
        this.printInfo();
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forge = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> mod.addListener(ForageClient::clientSetup));
        mod.register(ForageCraftDataGen.class);
        mod.addListener(ForageCraft::commonSetup);
        mod.register(ForageRegistry.class);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        if (!ForageInfo.IDE) {
            VerificationUtil.validateMod("foragecraft", "DE:00:69:E2:42:ED:EE:76:D9:64:AB:41:C7:0D:F5:A0:C3:6C:C7:BA:8D:6C:D3:64:2B:51:A1:D3:84:F1:6B:E3");
        }
        ForageFeatures.initFeatures();
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation("foragecraft:" + key);
    }

    public static String find(String key) {
        return "foragecraft:" + key;
    }

    private void printInfo() {
        LOGGER.info(String.format("Initializing %s.%s", "ForageCraft", !ForageInfo.IDE ? " See the debug log for build information." : ""));
        if (ForageInfo.IDE) {
            LOGGER.info(String.format("%s Build Information", "ForageCraft"));
            LOGGER.info(String.format(" - Version:     %s - %s", "2.0.0", "ForageCraft: Reborn"));
            LOGGER.info(String.format(" - Build Date:  %s", "2020-12-14T22:50:28-0500"));
            LOGGER.info(String.format(" - Dist:        %s", ForageInfo.DATAGEN ? "DATAGEN" : FMLEnvironment.dist.toString()));
            LOGGER.info(String.format(" - Environment: %s", ForageInfo.TESTSERVER ? "GitHub Actions Test Server" : "IDE/Gradle"));
        } else {
            LOGGER.debug(String.format("%s Build Information", "ForageCraft"));
            LOGGER.debug(String.format(" - Version:     %s - %s", "2.0.0", "ForageCraft: Reborn"));
            LOGGER.debug(String.format(" - Build Date:  %s", "2020-12-14T22:50:28-0500"));
            LOGGER.debug(String.format(" - Dist:        %s", FMLEnvironment.dist.toString()));
            LOGGER.debug(" - Environment: Normal");
            if (ForageInfo.FORCE_DEV_MIXINS) {
                LOGGER.warn("Dev-environment mixins for ForageCraft have been enabled!");
                LOGGER.warn("If you have no idea what you're doing, please remove the option from you JVM arguments.");
            }
        }
    }
}

