/*
 * Decompiled with CFR 0.152.
 */
package me.jonathing.minecraft.foragecraft.common.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import me.jonathing.minecraft.foragecraft.common.blocks.FlatRockBlock;
import me.jonathing.minecraft.foragecraft.common.blocks.LeekCropBlock;
import me.jonathing.minecraft.foragecraft.common.blocks.PavingStoneBlock;
import me.jonathing.minecraft.foragecraft.common.blocks.RockBlock;
import me.jonathing.minecraft.foragecraft.common.blocks.StickBlock;
import me.jonathing.minecraft.foragecraft.common.items.ForageItemGroups;
import me.jonathing.minecraft.foragecraft.common.registry.ForageRegistry;
import me.jonathing.minecraft.foragecraft.info.ForageInfo;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.HayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class ForageBlocks {
    public static Block rock;
    public static Block flat_rock;
    public static Block stick;
    public static Block straw_bale;
    public static Block fascine;
    public static Block paving_stones;
    public static Block leek_crop;
    public static Map<Block, ItemGroup> blockItemMap;
    public static Map<Block, Item.Properties> blockItemPropertiesMap;
    private static IForgeRegistry<Block> iBlockRegistry;

    public static void init(RegistryEvent.Register<Block> event) {
        iBlockRegistry = event.getRegistry();
        rock = ForageBlocks.register("rock", new RockBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200942_a().func_226896_b_().func_200946_b()), ItemGroup.field_78026_f, true);
        flat_rock = ForageBlocks.register("flat_rock", new FlatRockBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)rock)), ItemGroup.field_78026_f, true);
        stick = ForageBlocks.register("stick", new StickBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196662_n).func_200942_a().func_226896_b_().func_200946_b()), null, false);
        straw_bale = ForageBlocks.register("straw_bale", new HayBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150407_cf)), ItemGroup.field_78030_b, true);
        fascine = ForageBlocks.register("fascine", new HayBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150407_cf)), ItemGroup.field_78030_b, true);
        paving_stones = ForageBlocks.register("paving_stones", new PavingStoneBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b)), ItemGroup.field_78030_b, true);
        leek_crop = ForageBlocks.register("leek_crop", new LeekCropBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150464_aj)), null, false);
    }

    public static <B extends Block> B register(String key, B block, ItemGroup defaultItemGroup, boolean registerItem) {
        if (registerItem) {
            blockItemMap.put(block, ForageInfo.IDE ? ForageItemGroups.FORAGECRAFT : defaultItemGroup);
        }
        ForageRegistry.register(iBlockRegistry, key, block);
        return block;
    }

    public static <B extends Block> B register(String key, B block, Item.Properties itemProperties, ItemGroup defaultItemGroup, boolean registerItem) {
        blockItemPropertiesMap.put(block, itemProperties);
        return ForageBlocks.register(key, block, defaultItemGroup, registerItem);
    }

    static {
        blockItemMap = new LinkedHashMap<Block, ItemGroup>();
        blockItemPropertiesMap = new LinkedHashMap<Block, Item.Properties>();
    }
}

