/*
 * Decompiled with CFR 0.152.
 */
package me.jonathing.minecraft.foragecraft.common.security;

import java.util.function.Function;
import javax.annotation.Nullable;
import me.jonathing.minecraft.foragecraft.common.security.FingerprintInfo;
import me.jonathing.minecraft.foragecraft.common.security.FingerprintMismatchException;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VerificationUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private VerificationUtil() {
    }

    @Nullable
    private static FingerprintInfo getFingerprintInfo(ModFileInfo mod, String expectedFingerprint) {
        if (!FMLEnvironment.secureJarsEnabled) {
            return null;
        }
        return new FingerprintInfo(mod.getCodeSigningFingerprint().orElse(""), expectedFingerprint, mod.getTrustData().orElse(""));
    }

    public static void validateMod(String modId, String expectedSHA256) {
        VerificationUtil.validateMod(modId, expectedSHA256, shouldContinue -> {
            LOGGER.fatal(String.format("VerificationUtil failed to validate the certificate of mod %s since you gave an empty expected fingerprint.", modId));
            return false;
        });
    }

    public static void validateMod(String modId, String expectedSHA256, Function<String, Boolean> shouldContinue) {
        if (!ModList.get().getModContainerById(modId).isPresent()) {
            LOGGER.error(String.format("Could not validate mod %s since it is not present in the mod list!", modId));
            return;
        }
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modId).get();
        if (expectedSHA256.isEmpty()) {
            if (!shouldContinue.apply(modId).booleanValue()) {
                throw new NullPointerException(String.format("VerificationUtil failed to validate the certificate of mod %s. Please view the console for more information.", modId));
            }
            return;
        }
        FingerprintInfo modFingerprint = VerificationUtil.getFingerprintInfo((ModFileInfo)modContainer.getModInfo().getOwningFile(), expectedSHA256);
        if (modFingerprint == null) {
            LOGGER.fatal("FML has decided that Java is unable to check any of your mods for valid signature data.");
            LOGGER.fatal("This is very bad news. Please consider updating your Java version or scan your computer for viruses.");
            new FingerprintMismatchException(modId).printStackTrace();
        } else if (!modFingerprint.hasFingerprint()) {
            VerificationUtil.handleNoFingerprint(modId, modContainer.getModInfo());
        } else if (!modFingerprint.matchesExpectedFingerprint()) {
            VerificationUtil.handleFailedVerification(modId, modContainer.getModInfo(), modFingerprint);
        } else {
            VerificationUtil.handleSuccessfulVerification(modId, modFingerprint);
        }
    }

    public static boolean assumeUnsigned(String modId) {
        if (!ModList.get().getModContainerById(modId).isPresent()) {
            LOGGER.error(String.format("Could not validate mod %s since it is not present in the mod list!", modId));
            return true;
        }
        VerificationUtil.handleNoFingerprint(modId, ((ModContainer)ModList.get().getModContainerById(modId).get()).getModInfo());
        return true;
    }

    private static void handleNoFingerprint(String modId, IModInfo modInfo) {
        LOGGER.fatal(String.format("You are running an unsigned build of mod %s. If you do not know what you are doing, please close the game now and download a legitimate build from the mod author's distribution site of choice. Otherwise, please proceed with caution.", modId));
        ModLoader.get().addWarning(new ModLoadingWarning(modInfo, ModLoadingStage.VALIDATE, String.format("You are running an unsigned build of mod %s. If you don't know what you are doing, close the game now and read the message in console.", modId), new Object[]{new FingerprintMismatchException(modId)}));
    }

    private static void handleSuccessfulVerification(String modId, FingerprintInfo modFingerprint) {
        LOGGER.info(String.format("Verification of mod %s successful. Here is the signature data just in case:", modId));
        LOGGER.info(String.format(" - Expected Fingerprint: %s", modFingerprint.getExpectedFingerprint().toUpperCase()));
        LOGGER.info(String.format(" - Actual Fingerprint:   %s", modFingerprint.getFingerprint().toUpperCase()));
        LOGGER.info(String.format(" - Trust Data:           %s", modFingerprint.getTrustData()));
    }

    private static void handleFailedVerification(String modId, IModInfo modInfo, FingerprintInfo modFingerprint) {
        LOGGER.fatal(String.format("YOU ARE PLAYING A BUILD OF MOD %s THAT HAS BEEN SIGNED WITH AN UNAUTHORIZED FINGERPRINT!", modId.toUpperCase()));
        LOGGER.fatal("THIS IS VERY BAD NEWS. PLEASE RUN A COMPUTER VIRUS SCAN AND REPORT THIS TO THE MOD DEVELOPER AS SOON AS POSSIBLE.");
        LOGGER.fatal(String.format(" - Expected Fingerprint: %s", modFingerprint.getExpectedFingerprint().toUpperCase()));
        LOGGER.fatal(String.format(" - Actual Fingerprint:   %s", modFingerprint.getFingerprint().toUpperCase()));
        LOGGER.fatal(String.format(" - Trust Data:           %s", modFingerprint.getTrustData()));
        throw new ModLoadingException(modInfo, ModLoadingStage.VALIDATE, String.format("VerificationUtil failed to validate the certificate of mod %s. Please view the console for more information.", modId), (Throwable)new FingerprintMismatchException(modId), new Object[0]);
    }
}

