/*
 * Decompiled with CFR 0.152.
 */
package me.jonathing.minecraft.foragecraft.common.util;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class Quadruple<A, B, C, D>
implements Comparable<Quadruple<A, B, C, D>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final A first;
    private final B second;
    private final C third;
    private final D fourth;

    public Quadruple(A first, B second, C third, D fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public static <A, B, C, D> Quadruple<A, B, C, D> of(A first, B second, C third, D fourth) {
        return new Quadruple<A, B, C, D>(first, second, third, fourth);
    }

    @Override
    public int compareTo(Quadruple<A, B, C, D> other) {
        return new CompareToBuilder().append(this.first, other.first).append(this.second, other.second).append(this.third, other.third).append(this.fourth, other.fourth).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quadruple) {
            Quadruple other = (Quadruple)obj;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second) && Objects.equals(this.third, other.third) && Objects.equals(this.fourth, other.fourth);
        }
        return false;
    }

    public String toString() {
        return this.toString("(%s, %s, %s, %s)");
    }

    public String toString(String format) {
        return String.format(format, this.first.toString(), this.second.toString(), this.third.toString(), this.fourth.toString());
    }

    public int hashCode() {
        return (this.first == null ? 0 : this.first.hashCode()) ^ (this.second == null ? 0 : this.second.hashCode()) ^ (this.third == null ? 0 : this.third.hashCode()) ^ (this.fourth == null ? 0 : this.fourth.hashCode());
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public C getThird() {
        return this.third;
    }

    public D getFourth() {
        return this.fourth;
    }
}

