/*
 * Decompiled with CFR 0.152.
 */
package me.jonathing.minecraft.foragecraft.data.provider;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.jonathing.minecraft.foragecraft.common.blocks.LeekCropBlock;
import me.jonathing.minecraft.foragecraft.common.registry.ForageBlocks;
import me.jonathing.minecraft.foragecraft.common.registry.ForageItems;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ForageLootProvider
extends LootTableProvider {
    public ForageLootProvider(DataGenerator generator) {
        super(generator);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockLoot(), (Object)LootParameterSets.field_216267_h));
    }

    @ParametersAreNonnullByDefault
    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((location, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)location, (LootTable)table));
    }

    @Nonnull
    public String func_200397_b() {
        return "ForageCraft Loot Tables";
    }

    private static class BlockLoot
    extends BlockLootTables
    implements LootPoolUtil {
        private final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
        private final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
        private final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = this.SHEARS.func_216297_a(this.SILK_TOUCH);
        private final ILootCondition.IBuilder NOT_SILK_TOUCH_OR_SHEARS = this.SILK_TOUCH_OR_SHEARS.func_216298_a();
        private final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        private BlockLoot() {
        }

        protected void addTables() {
            this.blocks().forEach(block -> {
                if (block.equals(ForageBlocks.stick)) {
                    this.func_218493_a((Block)block, (IItemProvider)Items.field_151055_y);
                } else if (block.equals(ForageBlocks.leek_crop)) {
                    BlockStateProperty.Builder growthCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)LeekCropBlock.field_176488_a, ((LeekCropBlock)((Object)block)).func_185526_g()));
                    this.func_218522_a((Block)block, arg_0 -> this.lambda$null$0((ILootCondition.IBuilder)growthCondition, arg_0));
                } else {
                    this.func_218492_c((Block)block);
                }
            });
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        private Stream<Block> blocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("foragecraft") && !b.func_220068_i().equals((Object)LootTables.field_186419_a));
        }

        private void droppingSeedTag(Block block, ITag.INamedTag<Item> tag) {
            this.func_218507_a(block, BlockLoot.func_218511_b((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)((StandaloneLootEntry.Builder)TagLootEntry.func_216176_b(tag).func_212840_b_(RandomChance.func_216004_a((float)0.125f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)2))))));
        }

        private void silkOrElse(Block withSilk, IItemProvider without) {
            this.func_218522_a(withSilk, b -> BlockLoot.func_218515_b((Block)b, (IItemProvider)without));
        }

        private LootTable.Builder leaves(Block block, IItemProvider sapling, IItemProvider stick) {
            return BlockLoot.func_218535_c((Block)block, (LootEntry.Builder)((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])this.DEFAULT_SAPLING_DROP_RATES))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(this.NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)stick).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        private LootTable.Builder leavesFruit(Block block, IItemProvider sapling, IItemProvider stick, IItemProvider fruit) {
            float baseChance = 0.05f;
            float[] fortuneChances = new float[]{1.1111112f, 1.25f, 1.6666667f, 5.0f};
            return this.leaves(block, sapling, stick).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(this.NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)fruit))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{baseChance, baseChance * fortuneChances[0], baseChance * fortuneChances[1], baseChance * fortuneChances[2], baseChance * fortuneChances[3]}))));
        }

        private LootTable.Builder crop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food) {
            return this.crop(growthCondition, block, food, food);
        }

        private LootTable.Builder crop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food, IItemProvider seed) {
            LootPool.Builder seedPool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seed).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3).func_212840_b_(growthCondition)));
            LootPool.Builder foodPool = LootPool.func_216096_a().func_212840_b_(growthCondition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)food).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)1)));
            return (LootTable.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(seedPool).func_216040_a(foodPool));
        }

        private /* synthetic */ LootTable.Builder lambda$null$0(ILootCondition.IBuilder growthCondition, Block b) {
            return this.crop(growthCondition, b, (IItemProvider)ForageItems.leek, (IItemProvider)ForageItems.leek_seeds);
        }
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.func_216119_b();
            pools.forEach(pool -> table.func_216040_a(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.func_216119_b().func_216040_a(pool);
        }

        default public LootPool.Builder basicPool(IItemProvider item, int min, int max) {
            return LootPool.func_216096_a().func_216045_a(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(IItemProvider item) {
            return LootPool.func_216096_a().func_216045_a(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<IItemProvider> items) {
            return this.poolOf(items.stream().map(i -> this.basicEntry((IItemProvider)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootEntry.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.func_216096_a();
            lootEntries.forEach(entry -> pool.func_216045_a(entry));
            return pool;
        }

        default public StandaloneLootEntry.Builder<?> basicEntry(IItemProvider item, int min, int max) {
            return this.basicEntry(item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max)));
        }

        default public StandaloneLootEntry.Builder<?> basicEntry(IItemProvider item) {
            return ItemLootEntry.func_216168_a((IItemProvider)item);
        }
    }
}

