/*
 * Decompiled with CFR 0.152.
 */
package net.thedudemc.freelook.config.option;

import com.google.gson.annotations.Expose;
import net.thedudemc.freelook.config.option.Option;

public class NumericalRange
extends Option<Double> {
    @Expose
    private final Double min;
    @Expose
    private final Double max;

    public NumericalRange(Double defaultValue, Double minValue, Double maxValue, String comment) {
        super(defaultValue, comment);
        this.min = minValue;
        this.max = maxValue;
        this.withinRange(defaultValue);
    }

    public double clampValue(double value) {
        return this.clamp(value, this.min, this.max);
    }

    private double clamp(double num, double min, double max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    public boolean withinRange(double range) {
        if (this.min > this.max) {
            throw new IllegalArgumentException("Minimum value cannot be larger than maximum value!");
        }
        if (range < this.min) {
            throw new IllegalArgumentException("Value cannot be lower than minimum value!");
        }
        if (range > this.max) {
            throw new IllegalArgumentException("Value cannot be larger than maximum value!");
        }
        return true;
    }

    public void set(int range) {
        if (this.withinRange(range)) {
            this.value = (double)range;
        }
    }
}

