/*
 * Decompiled with CFR 0.152.
 */
package net.thedudemc.freelook.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.thedudemc.freelook.init.ModConfigs;
import net.thedudemc.freelook.init.ModKeybinds;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CameraEvents {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static ClientPlayerEntity player;
    private static float yaw;
    private static float pitch;
    private static float prevYaw;
    private static float prevPitch;
    private static float originalYaw;
    private static float originalPitch;
    private static float originalHeadYaw;
    private static double mouseDX;
    private static double mouseDY;
    private static double prevMouseX;
    private static double prevMouseY;
    private static long lerpStart;
    private static long lerpTimeElapsed;
    private static boolean initialPress;
    private static boolean isInterpolating;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onCameraUpdate(EntityViewRenderEvent.CameraSetup event) {
        if (player == null) {
            player = CameraEvents.mc.field_71439_g;
        }
        if (CameraEvents.mc.field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) {
            return;
        }
        if (isInterpolating) {
            CameraEvents.lockPlayerRotation();
            CameraEvents.interpolate(event);
        } else if (ModKeybinds.keyFreeLook.func_151470_d()) {
            if (initialPress) {
                CameraEvents.setup();
            }
            CameraEvents.lockPlayerRotation();
            CameraEvents.updateMouseInput();
            CameraEvents.updateCameraRotation(event);
            initialPress = false;
        } else if (!initialPress) {
            if (ModConfigs.FREELOOK.shouldInterpolate()) {
                event.setYaw(yaw);
                event.setPitch(pitch);
                lerpStart = System.currentTimeMillis();
                isInterpolating = true;
            } else {
                event.setYaw(originalYaw);
                event.setPitch(originalPitch);
            }
            initialPress = true;
        }
    }

    private static void setup() {
        originalYaw = CameraEvents.player.field_70177_z;
        originalPitch = CameraEvents.player.field_70125_A;
        originalHeadYaw = CameraEvents.player.field_70759_as;
        prevMouseX = CameraEvents.mc.field_71417_B.func_198024_e();
        prevMouseY = CameraEvents.mc.field_71417_B.func_198026_f();
    }

    private static void updateCameraRotation(EntityViewRenderEvent.CameraSetup event) {
        double dx = mouseDX * CameraEvents.getSensitivity() * 0.15;
        double dy = mouseDY * CameraEvents.getSensitivity() * 0.15;
        yaw = (float)dx - prevYaw + originalYaw;
        pitch = CameraEvents.mc.field_71474_y.field_74338_d ? (float)dy + prevPitch + originalPitch : (float)dy - prevPitch + originalPitch;
        if (ModConfigs.FREELOOK.shouldClamp()) {
            yaw = MathHelper.func_76131_a((float)yaw, (float)(originalYaw + -100.0f), (float)(originalYaw + 100.0f));
        }
        pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        event.setYaw(yaw);
        event.setPitch(pitch);
        prevYaw = (float)dx + prevYaw;
        prevPitch = (float)dy + prevPitch;
    }

    private static void interpolate(EntityViewRenderEvent.CameraSetup event) {
        double duration = ModConfigs.FREELOOK.getInterpolateSpeed() * 1000.0;
        float delta = System.currentTimeMillis() - lerpStart - lerpTimeElapsed;
        delta = (float)((double)delta / duration);
        float percentCompleted = (float)lerpTimeElapsed / (float)duration;
        float interpolatedYaw = CameraEvents.lerp(yaw, originalYaw, percentCompleted * 10.0f * delta);
        float interpolatedPitch = CameraEvents.lerp(pitch, originalPitch, percentCompleted * 10.0f * delta);
        event.setYaw(interpolatedYaw);
        event.setPitch(interpolatedPitch);
        yaw = interpolatedYaw;
        pitch = interpolatedPitch;
        lerpTimeElapsed = System.currentTimeMillis() - lerpStart;
        if ((double)lerpTimeElapsed >= duration) {
            CameraEvents.reset(event);
        }
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static void reset(EntityViewRenderEvent.CameraSetup event) {
        event.setYaw(originalYaw);
        event.setPitch(originalPitch);
        isInterpolating = false;
        lerpTimeElapsed = 0L;
        yaw = 0.0f;
        pitch = 0.0f;
        prevYaw = 0.0f;
        prevPitch = 0.0f;
        originalYaw = 0.0f;
        originalPitch = 0.0f;
        mouseDX = 0.0;
        mouseDY = 0.0;
        prevMouseX = 0.0;
        prevMouseY = 0.0;
    }

    private static void lockPlayerRotation() {
        CameraEvents.player.field_70177_z = originalYaw;
        CameraEvents.player.field_70125_A = originalPitch;
        CameraEvents.player.field_70759_as = originalHeadYaw;
    }

    private static void updateMouseInput() {
        mouseDX = prevMouseX - CameraEvents.mc.field_71417_B.func_198024_e();
        mouseDY = prevMouseY - CameraEvents.mc.field_71417_B.func_198026_f();
        prevMouseX = CameraEvents.mc.field_71417_B.func_198024_e();
        prevMouseY = CameraEvents.mc.field_71417_B.func_198026_f();
    }

    private static double getSensitivity() {
        return CameraEvents.mc.field_71474_y.field_74341_c * 0.6 * 0.2 * 8.0;
    }

    static {
        lerpStart = 0L;
        lerpTimeElapsed = 0L;
        initialPress = true;
        isInterpolating = false;
    }
}

