/*
 * Decompiled with CFR 0.152.
 */
package net.thedudemc.freelook.event;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.EditBookScreen;
import net.minecraft.client.gui.screen.EnchantmentScreen;
import net.minecraft.client.gui.screen.GrindstoneScreen;
import net.minecraft.client.gui.screen.HopperScreen;
import net.minecraft.client.gui.screen.LoomScreen;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.AnvilScreen;
import net.minecraft.client.gui.screen.inventory.BeaconScreen;
import net.minecraft.client.gui.screen.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screen.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screen.inventory.CartographyTableScreen;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.DispenserScreen;
import net.minecraft.client.gui.screen.inventory.FurnaceScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.screen.inventory.MerchantScreen;
import net.minecraft.client.gui.screen.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.screen.inventory.SmokerScreen;
import net.minecraft.client.gui.screen.inventory.StonecutterScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.MovementInput;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.thedudemc.freelook.FreeLook;
import net.thedudemc.freelook.init.ModConfigs;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InventoryEvents {
    @SubscribeEvent
    public static void onInputUpdate(InputUpdateEvent event) {
        if (!ModConfigs.FREELOOK.shouldMoveInInventory()) {
            return;
        }
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (InventoryEvents.canMoveIn(currentScreen) && !InventoryEvents.inTextField(currentScreen)) {
            KeyBinding.func_186704_a();
            InventoryEvents.movePlayer(event.getMovementInput(), Minecraft.func_71410_x().field_71439_g.func_225608_bj_(), Minecraft.func_71410_x().field_71439_g.func_175149_v());
        }
    }

    public static boolean canMoveIn(Screen screen) {
        if (screen == null) {
            return false;
        }
        IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
        if (screen.func_231177_au__() && Minecraft.func_71410_x().func_71356_B() && server != null && server.func_71344_c()) {
            return false;
        }
        if (screen instanceof InventoryScreen) {
            return true;
        }
        if (screen instanceof CreativeScreen) {
            return true;
        }
        if (screen instanceof CraftingScreen) {
            return true;
        }
        if (screen instanceof ChestScreen) {
            return true;
        }
        if (screen instanceof ShulkerBoxScreen) {
            return true;
        }
        if (screen instanceof DispenserScreen) {
            return true;
        }
        if (screen instanceof HopperScreen) {
            return true;
        }
        if (screen instanceof EnchantmentScreen) {
            return true;
        }
        if (screen instanceof AnvilScreen) {
            return true;
        }
        if (screen instanceof BeaconScreen) {
            return true;
        }
        if (screen instanceof BrewingStandScreen) {
            return true;
        }
        if (screen instanceof FurnaceScreen) {
            return true;
        }
        if (screen instanceof BlastFurnaceScreen) {
            return true;
        }
        if (screen instanceof SmokerScreen) {
            return true;
        }
        if (screen instanceof LoomScreen) {
            return true;
        }
        if (screen instanceof CartographyTableScreen) {
            return true;
        }
        if (screen instanceof GrindstoneScreen) {
            return true;
        }
        if (screen instanceof StonecutterScreen) {
            return true;
        }
        if (screen instanceof MerchantScreen) {
            return true;
        }
        if (screen instanceof ReadBookScreen) {
            return true;
        }
        return screen instanceof EditBookScreen;
    }

    public static void movePlayer(MovementInput input, boolean slow, boolean isSpectator) {
        input.field_187255_c = InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74351_w);
        input.field_187256_d = InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74368_y);
        input.field_187257_e = InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74370_x);
        input.field_187258_f = InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74366_z);
        float f = input.field_187255_c == input.field_187256_d ? 0.0f : (input.field_192832_b = (float)(input.field_187255_c ? 1 : -1));
        input.field_78902_a = input.field_187257_e == input.field_187258_f ? 0.0f : (float)(input.field_187257_e ? 1 : -1);
        input.field_78901_c = InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74314_A);
        input.field_228350_h_ = InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_228046_af_);
        if (!isSpectator && (input.field_228350_h_ || slow)) {
            input.field_78902_a = (float)((double)input.field_78902_a * 0.3);
            input.field_192832_b = (float)((double)input.field_192832_b * 0.3);
        }
        if (InventoryEvents.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_151444_V)) {
            Minecraft.func_71410_x().field_71439_g.func_70031_b(true);
        }
    }

    private static boolean isKeyDown(KeyBinding key) {
        try {
            return (Boolean)ObfuscationReflectionHelper.getPrivateValue(KeyBinding.class, (Object)key, (String)"field_74513_e");
        }
        catch (Exception e) {
            FreeLook.LOGGER.warn("Access Error: KeyBinding.pressed - Key: \"" + key + "\": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static boolean inTextField(Screen screen) {
        try {
            Field[] fs;
            for (Field f : fs = InventoryEvents.getDeclaredFieldsSuper(screen.getClass())) {
                TextFieldWidget tfw;
                f.setAccessible(true);
                if (!TextFieldWidget.class.isAssignableFrom(f.getType()) || (tfw = (TextFieldWidget)f.get(screen)) == null || !tfw.func_212955_f()) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (screen instanceof IRecipeShownListener) {
            try {
                TextFieldWidget searchBar = (TextFieldWidget)ObfuscationReflectionHelper.getPrivateValue(RecipeBookGui.class, (Object)((IRecipeShownListener)screen).func_194310_f(), (String)"field_193962_q");
                if (searchBar.func_212955_f()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Field[] getDeclaredFieldsSuper(Class aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGUIDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        Screen screen = event.getGui();
        if (InventoryEvents.canMoveIn(screen)) {
            RenderSystem.translatef((float)10000.0f, (float)10000.0f, (float)0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGUIBackgroundDraw(GuiScreenEvent.BackgroundDrawnEvent event) {
        Screen screen = event.getGui();
        if (InventoryEvents.canMoveIn(screen)) {
            RenderSystem.translatef((float)-10000.0f, (float)-10000.0f, (float)0.0f);
        }
    }
}

