/*
 * Decompiled with CFR 0.152.
 */
package net.thedudemc.freelook;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.thedudemc.freelook.FreeLookClient;
import net.thedudemc.freelook.FreeLookConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="freelook")
public class EventHandler {
    public static boolean toggleEnabled = false;
    public static boolean initialPress = false;
    public static boolean isFreeLooking = false;

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        initialPress = false;
        toggleEnabled = false;
        isFreeLooking = false;
        Camera.setView();
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (player.func_184613_cA() && mc.field_71474_y.field_74320_O > 0) {
            Camera.resetView();
            return;
        }
        if (player.func_184187_bx() == null) {
            if (!toggleEnabled) {
                if (FreeLookClient.keyFreeLook.func_151470_d()) {
                    if (!initialPress) {
                        Camera.setView();
                        initialPress = true;
                    } else {
                        Camera.update(event.phase == TickEvent.Phase.START);
                    }
                } else if (initialPress) {
                    Camera.resetView();
                    initialPress = false;
                }
            } else if (isFreeLooking) {
                Camera.handleToggledFreeLook(event.phase == TickEvent.Phase.START);
            } else {
                Camera.resetView();
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (FreeLookClient.keyToggleMode.func_151468_f()) {
            boolean bl = toggleEnabled = !toggleEnabled;
            if (!toggleEnabled) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "FreeLook Mode: Hold"));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "FreeLook Mode: Toggle"));
            }
        }
        if (player.func_184187_bx() == null && FreeLookClient.keyFreeLook.func_151468_f() && toggleEnabled) {
            isFreeLooking = !isFreeLooking;
        }
    }

    public static class Camera {
        public static boolean enabled = false;
        public static float cameraYaw = 0.0f;
        public static float cameraPitch = 0.0f;
        public static float playerYaw = 0.0f;
        public static float playerPitch = 0.0f;
        public static float originalYaw = 0.0f;
        public static float originalPitch = 0.0f;
        static double mouseX;
        static double mouseY;
        static double mouseDX;
        static double mouseDY;
        private static Minecraft mc;
        private static boolean firstRun;

        public static void setView() {
            playerYaw = originalYaw = Camera.mc.field_71439_g.field_70177_z;
            cameraYaw = originalYaw;
            playerPitch = cameraPitch = (originalPitch = -Camera.mc.field_71439_g.field_70125_A);
            enabled = true;
        }

        private static void updateView() {
            if (!mc.func_195544_aj() || !enabled) {
                return;
            }
            if (firstRun) {
                mouseX = Camera.mc.field_71417_B.func_198024_e();
                mouseY = Camera.mc.field_71417_B.func_198026_f();
                mouseDX = 0.0;
                mouseDY = 0.0;
                firstRun = false;
            } else {
                mouseDX = mouseX - Camera.mc.field_71417_B.func_198024_e();
                mouseDY = mouseY - Camera.mc.field_71417_B.func_198026_f();
                mouseX = Camera.mc.field_71417_B.func_198024_e();
                mouseY = Camera.mc.field_71417_B.func_198026_f();
            }
            double f = Camera.mc.field_71474_y.field_74341_c * (double)0.6f + (double)0.2f;
            double f1 = f * f * f * 8.0;
            double dx = mouseDX * f1 * 0.15;
            double dy = mouseDY * f1 * 0.15;
            cameraYaw = (float)((double)cameraYaw - dx);
            cameraPitch = (float)((double)cameraPitch + dy);
            cameraPitch = MathHelper.func_76131_a((float)cameraPitch, (float)-90.0f, (float)90.0f);
            if (FreeLookConfig.getViewClamping()) {
                cameraYaw = MathHelper.func_76131_a((float)cameraYaw, (float)(originalYaw + -100.0f), (float)(originalYaw + 100.0f));
            }
        }

        public static void resetView() {
            cameraYaw = originalYaw;
            cameraPitch = originalPitch;
            playerYaw = originalYaw;
            playerPitch = originalPitch;
            enabled = false;
            firstRun = true;
        }

        public static void update(boolean start) {
            Entity player = mc.func_175606_aa();
            if (player == null) {
                return;
            }
            if (enabled) {
                Camera.updateView();
                if (start) {
                    player.field_70177_z = player.field_70126_B = cameraYaw;
                    player.field_70125_A = player.field_70127_C = -cameraPitch;
                } else {
                    player.field_70177_z = Camera.mc.field_71439_g.field_70177_z - cameraYaw + playerYaw;
                    player.field_70126_B = Camera.mc.field_71439_g.field_70126_B - cameraYaw + playerYaw;
                    player.field_70125_A = -playerPitch;
                    player.field_70127_C = -playerPitch;
                }
            }
        }

        public static void handleToggledFreeLook(boolean start) {
            Entity player = mc.func_175606_aa();
            if (player == null || !mc.func_195544_aj()) {
                return;
            }
            if (!enabled) {
                Camera.setView();
                enabled = true;
            }
            Camera.updateView();
            if (start) {
                player.field_70177_z = player.field_70126_B = cameraYaw;
                player.field_70125_A = player.field_70127_C = -cameraPitch;
            } else {
                player.field_70177_z = Camera.mc.field_71439_g.field_70177_z - cameraYaw + playerYaw;
                player.field_70126_B = Camera.mc.field_71439_g.field_70126_B - cameraYaw + playerYaw;
                player.field_70125_A = -playerPitch;
                player.field_70127_C = -playerPitch;
            }
        }

        static {
            mc = Minecraft.func_71410_x();
        }
    }
}

