/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import dev.ftb.mods.ftblibrary.FTBLibraryCommon;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.IconPresets;
import dev.ftb.mods.ftblibrary.icon.IconRenderer;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.TextureStitchEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.hooks.ScreenHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.ReloadListeners;
import net.minecraft.class_1059;
import net.minecraft.class_1269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_485;
import org.jetbrains.annotations.Nullable;

public class FTBLibraryClient
extends FTBLibraryCommon {
    public static final List<IconRenderer<?>> ICON_RENDERERS = new ArrayList();
    public static int showButtons = 1;
    public CursorType lastCursorType = null;

    @Override
    public void init() {
        if (Platform.isModLoaded((String)"roughlyenoughitems") && !Platform.getMod((String)"roughlyenoughitems").getVersion().startsWith("5.")) {
            showButtons = 3;
        }
        if (class_310.method_1551() == null) {
            return;
        }
        TextureStitchEvent.PRE.register(this::textureStitch);
        GuiEvent.INIT_POST.register(this::guiInit);
        GuiEvent.RENDER_PRE.register(this::renderTick);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ReloadListeners.registerReloadListener((class_3264)class_3264.field_14188, (class_3302)SidebarButtonManager.INSTANCE);
    }

    private void textureStitch(class_1059 atlas, Consumer<class_2960> addSprite) {
        if (!atlas.method_24106().equals((Object)class_1059.field_5275)) {
            return;
        }
        try {
            for (Field field : Icons.class.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(null);
                if (!(o instanceof AtlasSpriteIcon)) continue;
                AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                addSprite.accept(a.id);
                IconPresets.MAP.put(a.id.toString(), a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class_1269 renderTick(class_437 screen, class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!ICON_RENDERERS.isEmpty()) {
            for (IconRenderer<?> iconRenderer : ICON_RENDERERS) {
                iconRenderer.render();
            }
        }
        return class_1269.field_5811;
    }

    private void guiInit(class_437 screen, List<class_339> abstractWidgets, List<class_364> guiEventListeners) {
        if (FTBLibraryClient.areButtonsVisible(screen)) {
            SidebarGroupGuiButton group = new SidebarGroupGuiButton((class_465)screen);
            ScreenHooks.addButton((class_437)screen, (class_339)group);
        }
    }

    private void clientTick(class_310 client) {
        CursorType t;
        CursorType cursorType = t = client.field_1755 instanceof IScreenWrapper ? ((IScreenWrapper)client.field_1755).getGui().getCursor() : null;
        if (this.lastCursorType != t) {
            this.lastCursorType = t;
            CursorType.set(t);
        }
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable class_437 gui) {
        if (showButtons == 0 || showButtons == 2 && !(gui instanceof class_485) || showButtons == 3) {
            return false;
        }
        return gui instanceof class_465 && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }

    @Override
    public void testScreen() {
        ConfigGroup group = new ConfigGroup("test");
        group.add("image", new ImageConfig(), "", v -> {}, "");
        new EditConfigScreen(group).openGuiLater();
    }
}

