/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.BooleanConfig;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.EnumConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class ConfigGroup {
    public final String id;
    public ConfigGroup parent;
    private final Map<String, ConfigValue> values;
    private final Map<String, ConfigGroup> groups;
    public ConfigCallback savedCallback;
    private String nameKey;

    public ConfigGroup(String i) {
        this.id = i;
        this.values = new LinkedHashMap<String, ConfigValue>();
        this.groups = new LinkedHashMap<String, ConfigGroup>();
        this.savedCallback = null;
        this.nameKey = "";
    }

    public String getNameKey() {
        return this.nameKey.isEmpty() ? this.getPath() : this.nameKey;
    }

    public ConfigGroup setNameKey(String key) {
        this.nameKey = key;
        return this;
    }

    public class_2561 getName() {
        return new class_2588(this.getNameKey());
    }

    public class_2561 getTooltip() {
        String t = this.getNameKey() + ".tooltip";
        return class_1074.method_4663((String)t) ? new class_2588(t) : class_2585.field_24366;
    }

    public ConfigGroup getGroup(String id) {
        int index = id.indexOf(46);
        if (index == -1) {
            ConfigGroup g = this.groups.get(id);
            if (g == null) {
                g = new ConfigGroup(id);
                g.parent = this;
                this.groups.put(g.id, g);
            }
            return g;
        }
        return this.getGroup(id.substring(0, index)).getGroup(id.substring(index + 1));
    }

    public <T, CV extends ConfigValue<T>> CV add(String id, CV type, @Nullable T value, Consumer<T> callback, @Nullable T defaultValue) {
        type.init(this, id, value, callback, defaultValue);
        this.values.put(id, type);
        return type;
    }

    public BooleanConfig addBool(String id, boolean value, Consumer<Boolean> setter, boolean def) {
        return this.add(id, new BooleanConfig(), value, setter, def);
    }

    public IntConfig addInt(String id, int value, Consumer<Integer> setter, int def, int min, int max) {
        return this.add(id, new IntConfig(min, max), value, setter, def);
    }

    public LongConfig addLong(String id, long value, Consumer<Long> setter, long def, long min, long max) {
        return this.add(id, new LongConfig(min, max), value, setter, def);
    }

    public DoubleConfig addDouble(String id, double value, Consumer<Double> setter, double def, double min, double max) {
        return this.add(id, new DoubleConfig(min, max), value, setter, def);
    }

    public StringConfig addString(String id, String value, Consumer<String> setter, String def, @Nullable Pattern pattern) {
        return this.add(id, new StringConfig(pattern), value, setter, def);
    }

    public StringConfig addString(String id, String value, Consumer<String> setter, String def) {
        return this.addString(id, value, setter, def, null);
    }

    public <E> EnumConfig<E> addEnum(String id, E value, Consumer<E> setter, NameMap<E> nameMap, E def) {
        return this.add(id, new EnumConfig<E>(nameMap), value, setter, def);
    }

    public <E> EnumConfig<E> addEnum(String id, E value, Consumer<E> setter, NameMap<E> nameMap) {
        return this.addEnum(id, value, setter, nameMap, nameMap.defaultValue);
    }

    public <E, CV extends ConfigValue<E>> ListConfig<E, CV> addList(String id, List<E> c, CV type, E def) {
        type.defaultValue = def;
        return this.add(id, new ListConfig(type), c, t -> {
            c.clear();
            c.addAll((Collection)t);
        }, Collections.emptyList());
    }

    public EnumConfig<Tristate> addTristate(String id, Tristate value, Consumer<Tristate> setter, Tristate def) {
        return this.addEnum(id, value, setter, Tristate.NAME_MAP, def);
    }

    public EnumConfig<Tristate> addTristate(String id, Tristate value, Consumer<Tristate> setter) {
        return this.addTristate(id, value, setter, Tristate.DEFAULT);
    }

    public ItemStackConfig addItemStack(String id, class_1799 value, Consumer<class_1799> setter, class_1799 def, boolean singleItemOnly, boolean allowEmpty) {
        return this.add(id, new ItemStackConfig(singleItemOnly, allowEmpty), value, setter, def);
    }

    public final Collection<ConfigValue> getValues() {
        return this.values.values();
    }

    public final Collection<ConfigGroup> getGroups() {
        return this.groups.values();
    }

    public String getPath() {
        if (this.parent == null) {
            return this.id;
        }
        return this.parent.getPath() + '.' + this.id;
    }

    public void save(boolean accepted) {
        if (accepted) {
            for (ConfigValue value : this.values.values()) {
                value.setter.accept(value.value);
            }
        }
        for (ConfigGroup group : this.groups.values()) {
            group.save(accepted);
        }
        if (this.savedCallback != null) {
            this.savedCallback.save(accepted);
        }
    }
}

