/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class EditConfigFromStringScreen<T>
extends BaseScreen {
    private final ConfigFromString<T> config;
    private final ConfigCallback callback;
    private T current;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final TextBox textBox;

    public static <E> void open(ConfigFromString<E> type, @Nullable E value, @Nullable E defaultValue, ConfigCallback callback) {
        ConfigGroup group = new ConfigGroup("group");
        group.add("value", type, value, e -> {}, defaultValue);
        new EditConfigFromStringScreen<E>(type, callback).openGui();
    }

    public EditConfigFromStringScreen(ConfigFromString<T> c, ConfigCallback cb) {
        this.setSize(230, 54);
        this.config = c;
        this.callback = cb;
        this.current = this.config.value == null ? null : this.config.copy(this.config.value);
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, (class_2561)new class_2588("gui.cancel"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                EditConfigFromStringScreen.this.callback.save(false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, (class_2561)new class_2588("gui.accept"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                EditConfigFromStringScreen.this.config.setCurrentValue(EditConfigFromStringScreen.this.current);
                EditConfigFromStringScreen.this.callback.save(true);
            }

            @Override
            public WidgetType getWidgetType() {
                return EditConfigFromStringScreen.this.config.getCanEdit() && EditConfigFromStringScreen.this.textBox.isTextValid() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.textBox = new TextBox(this){

            @Override
            public boolean allowInput() {
                return EditConfigFromStringScreen.this.config.getCanEdit();
            }

            @Override
            public boolean isValid(String txt) {
                return EditConfigFromStringScreen.this.config.parse(null, txt);
            }

            @Override
            public void onTextChanged() {
                EditConfigFromStringScreen.this.config.parse(t -> {
                    EditConfigFromStringScreen.this.current = t;
                    this.textColor = EditConfigFromStringScreen.this.config.getColor(t);
                }, this.getText());
            }

            @Override
            public void onEnterPressed() {
                if (EditConfigFromStringScreen.this.config.getCanEdit()) {
                    EditConfigFromStringScreen.this.buttonAccept.onClicked(MouseButton.LEFT);
                }
            }
        };
        this.textBox.setPosAndSize(8, 8, this.width - 16, 16);
        this.textBox.setText(this.config.getStringFromValue(this.current));
        this.textBox.textColor = this.config.getColor(this.current);
        this.textBox.setCursorPosition(this.textBox.getText().length());
        this.textBox.setFocused(true);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.config.setCurrentValue(this.current);
            this.callback.save(true);
            return false;
        }
        return false;
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public boolean doesGuiPauseGame() {
        class_437 screen = this.getPrevScreen();
        return screen != null && screen.method_25421();
    }
}

