/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2519;

public class EnumValue<T>
extends BaseValue<T> {
    private final NameMap<T> nameMap;

    EnumValue(SNBTConfig c, String n, NameMap<T> nm) {
        super(c, n, nm.defaultValue);
        this.nameMap = nm;
    }

    @Override
    public void set(T v) {
        if (this.nameMap.values.contains(v)) {
            super.set(v);
        } else {
            super.set(this.defaultValue);
        }
    }

    @Override
    public void write(SNBTCompoundTag tag) {
        ArrayList<String> s = new ArrayList<String>(this.comment);
        s.add("Default: \"" + this.nameMap.getName(this.defaultValue) + "\"");
        s.add("Valid values: " + this.nameMap.keys.stream().map(class_2519::method_10706).collect(Collectors.joining(", ")));
        tag.comment(this.key, String.join((CharSequence)"\n", s));
        tag.method_10582(this.key, this.nameMap.getName(this.get()));
    }

    @Override
    public void read(SNBTCompoundTag tag) {
        this.set(this.nameMap.get(tag.method_10558(this.key)));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void createClientConfig(ConfigGroup group) {
        group.addEnum(this.key, this.get(), this::set, this.nameMap).setCanEdit(this.enabled.getAsBoolean());
    }
}

