/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.fabric.GuiHelperImpl;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1041;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();
    public static final BaseScreen BLANK_GUI = new BaseScreen(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };

    public static void setupDrawing() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        class_308.method_1450();
    }

    public static void playSound(class_3414 event, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)pitch));
    }

    public static void drawTexturedRect(class_4587 matrixStack, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (u0 == u1 || v0 == v1) {
            class_289 tesselator = class_289.method_1348();
            class_287 buffer = tesselator.method_1349();
            buffer.method_1328(7, class_290.field_1576);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, h, col);
            tesselator.method_1350();
        } else {
            class_289 tesselator = class_289.method_1348();
            class_287 buffer = tesselator.method_1349();
            buffer.method_1328(7, class_290.field_20887);
            GuiHelper.addRectToBufferWithUV(matrixStack, buffer, x, y, w, h, col, u0, v0, u1, v1);
            tesselator.method_1350();
        }
    }

    public static void addRectToBuffer(class_4587 matrixStack, class_287 buffer, int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0) {
            return;
        }
        class_1159 m = matrixStack.method_23760().method_23761();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_1344();
    }

    public static void addRectToBufferWithUV(class_4587 matrixStack, class_287 buffer, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (w <= 0 || h <= 0) {
            return;
        }
        class_1159 m = matrixStack.method_23760().method_23761();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(u0, v1).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(u1, v1).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u1, v0).method_1344();
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u0, v0).method_1344();
    }

    public static void drawHollowRect(class_4587 matrixStack, int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(matrixStack, x, y, w, h);
            return;
        }
        RenderSystem.disableTexture();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(7, class_290.field_1576);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, w, 1, col);
        }
        tesselator.method_1350();
        RenderSystem.enableTexture();
    }

    public static void drawRectWithShade(class_4587 matrixStack, int x, int y, int w, int h, Color4I col, int intensity) {
        RenderSystem.disableTexture();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(7, class_290.field_1576);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 1, 1, col);
        tesselator.method_1350();
        RenderSystem.enableTexture();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_327 getFont(class_1799 stack) {
        return GuiHelperImpl.getFont(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean shouldShowDurability(class_1799 stack) {
        return GuiHelperImpl.shouldShowDurability(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getDamageLevel(class_1799 stack) {
        return GuiHelperImpl.getDamageLevel(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getDurabilityColor(class_1799 stack) {
        return GuiHelperImpl.getDurabilityColor(stack);
    }

    public static boolean drawItem(class_4587 matrixStack, class_1799 stack, double x, double y, float scaleX, float scaleY, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.method_7960() || (double)scaleX == 0.0 || (double)scaleY == 0.0) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        class_289 tesselator = class_289.method_1348();
        class_918 itemRenderer = mc.method_1480();
        matrixStack.method_22903();
        matrixStack.method_22904(x, y, 0.0);
        matrixStack.method_22905(scaleX, scaleY, 1.0f);
        mc.method_1531().method_22813(class_1059.field_5275);
        mc.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.enableRescaleNormal();
        GuiHelper.setupDrawing();
        matrixStack.method_22904(8.0, 8.0, (double)itemRenderer.field_4730);
        matrixStack.method_22905(1.0f, -1.0f, 1.0f);
        matrixStack.method_22905(16.0f, 16.0f, 16.0f);
        class_4597.class_4598 renderTypeBufferImpl = mc.method_22940().method_23000();
        class_1087 bakedModel = itemRenderer.method_4019(stack, (class_1937)mc.field_1687, (class_1309)mc.field_1724);
        boolean bl = flatLight = !bakedModel.method_24304();
        if (flatLight) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_809.class_811.field_4317, false, matrixStack, (class_4597)renderTypeBufferImpl, 0xF000F0, class_4608.field_21444, bakedModel);
        renderTypeBufferImpl.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            class_308.method_24211();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        if (renderOverlay) {
            float f3;
            class_327 fr = GuiHelper.getFont(stack);
            if (fr == null) {
                fr = mc.field_1772;
            }
            if (stack.method_7947() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.method_7947()) : text;
                matrixStack.method_22904(0.0, 0.0, (double)(itemRenderer.field_4730 + 20.0f));
                fr.method_27521(s, (float)(17 - fr.method_1727(s)), 9.0f, 0xFFFFFF, true, matrixStack.method_23760().method_23761(), (class_4597)renderTypeBufferImpl, false, 0, 0xF000F0);
                renderTypeBufferImpl.method_22993();
            }
            if (GuiHelper.shouldShowDurability(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                double health = GuiHelper.getDamageLevel(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = GuiHelper.getDurabilityColor(stack);
                GuiHelper.draw(matrixStack, tesselator, 2, 13, 13, 2, 0, 0, 0, 255);
                GuiHelper.draw(matrixStack, tesselator, 2, 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = mc.field_1724 == null ? 0.0f : mc.field_1724.method_7357().method_7905(stack.method_7909(), mc.method_1488());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                GuiHelper.draw(matrixStack, tesselator, 0, class_3532.method_15375((float)(16.0f * (1.0f - f3))), 16, class_3532.method_15386((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
        matrixStack.method_22909();
        return true;
    }

    private static void draw(class_4587 matrixStack, class_289 tesselator, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        class_1159 m = matrixStack.method_23760().method_23761();
        class_287 renderer = tesselator.method_1349();
        renderer.method_1328(7, class_290.field_1576);
        renderer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)x, (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        tesselator.method_1350();
    }

    public static void pushScissor(class_1041 screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(class_1041 screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static String clickEventToString(@Nullable class_2558 event) {
        if (event == null) {
            return "";
        }
        switch (event.method_10845()) {
            case field_11749: 
            case field_11748: {
                return event.method_10844();
            }
            case field_11746: {
                return "file:" + event.method_10844();
            }
            case field_11750: {
                return "command:" + event.method_10844();
            }
            case field_11745: {
                return "suggest_command:" + event.method_10844();
            }
        }
        return "";
    }

    public static void addStackTooltip(class_1799 stack, List<class_2561> list) {
        GuiHelper.addStackTooltip(stack, list, null);
    }

    public static void addStackTooltip(class_1799 stack, List<class_2561> list, @Nullable class_2561 prefix) {
        List tooltip = stack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934));
        list.add((class_2561)(prefix == null ? ((class_2561)tooltip.get(0)).method_27661().method_27692(stack.method_7932().field_8908) : prefix.method_27661().method_10852((class_2561)tooltip.get(0))));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add((class_2561)new class_2585("").method_27692(class_124.field_1080).method_10852((class_2561)tooltip.get(i)));
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(class_1041 screen) {
            double scale = screen.method_4495();
            int sx = (int)((double)this.x * scale);
            int sy = (int)((double)(screen.method_4502() - (this.y + this.h)) * scale);
            int sw = (int)((double)this.w * scale);
            int sh = (int)((double)this.h * scale);
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

