/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class TooltipList {
    private final List<class_2561> lines = new ArrayList<class_2561>();
    public int zOffset = 950;
    public int zOffsetItemTooltip = 0;
    public int backgroundColor = -267386864;
    public int borderColorStart = 0x505000FF;
    public int borderColorEnd = (this.borderColorStart & 0xFEFEFE) >> 1 | this.borderColorStart & 0xFF000000;
    public int maxWidth = 0;
    public int xOffset = 0;
    public int yOffset = 0;

    public boolean shouldRender() {
        return !this.lines.isEmpty();
    }

    public void reset() {
        this.lines.clear();
        this.zOffset = 950;
        this.zOffsetItemTooltip = 0;
        this.backgroundColor = -267386864;
        this.borderColorStart = 0x505000FF;
        this.borderColorEnd = (this.borderColorStart & 0xFEFEFE) >> 1 | this.borderColorStart & 0xFF000000;
        this.maxWidth = 0;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public void add(class_2561 component) {
        this.lines.add(component);
    }

    public void blankLine() {
        this.add(class_2585.field_24366);
    }

    public void styledString(String text, class_2583 style) {
        this.add((class_2561)new class_2585(text).method_27696(style));
    }

    public void styledString(String text, class_124 color) {
        this.add((class_2561)new class_2585(text).method_27692(color));
    }

    public void styledTranslate(String key, class_2583 style, Object ... objects) {
        this.add((class_2561)new class_2588(key, objects).method_27696(style));
    }

    public void string(String text) {
        this.styledString(text, class_2583.field_24360);
    }

    public void translate(String key, Object ... objects) {
        this.styledTranslate(key, class_2583.field_24360, objects);
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 mStack, int mouseX, int mouseY, int screenWidth, int screenHeight, class_327 font) {
        boolean bl;
        mouseX += this.xOffset;
        mouseY += this.yOffset;
        ArrayList<class_5481> textLines = new ArrayList<class_5481>(this.lines.size());
        for (class_2561 class_25612 : this.lines) {
            textLines.add(class_25612.method_30937());
        }
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (class_5481 textLine : textLines) {
            int textLineWidth = font.method_30880(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean bl2 = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            boolean bl3 = true;
        }
        if (this.maxWidth > 0 && tooltipTextWidth > this.maxWidth) {
            tooltipTextWidth = this.maxWidth;
            bl = true;
        }
        if (bl) {
            int wrappedTooltipWidth = 0;
            ArrayList<class_5481> wrappedTextLines = new ArrayList<class_5481>();
            for (int i = 0; i < this.lines.size(); ++i) {
                class_2561 textLine = this.lines.get(i);
                List wrappedLine = font.method_1728((class_5348)textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (class_5481 line : wrappedLine) {
                    int lineWidth = font.method_30880(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        mStack.method_22903();
        mStack.method_22904(0.0, 0.0, (double)this.zOffset);
        class_1159 mat = mStack.method_23760().method_23761();
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(7, class_290.field_1576);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, this.borderColorStart, this.borderColorEnd);
        TooltipList.drawGradientRect(mat, buffer, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, this.borderColorStart, this.borderColorEnd);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, this.borderColorStart, this.borderColorStart);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, this.borderColorEnd, this.borderColorEnd);
        tesselator.method_1350();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        class_4597.class_4598 renderType = class_4597.method_22991((class_287)buffer);
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            class_5481 line = (class_5481)textLines.get(lineNumber);
            if (line != null) {
                font.method_22942(line, (float)tooltipX, (float)tooltipY, -1, true, mat, (class_4597)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.method_22993();
        mStack.method_22909();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    @Environment(value=EnvType.CLIENT)
    private static void drawGradientRect(class_1159 mat, class_287 buffer, int left, int top, int right, int bottom, int startColor, int endColor) {
        int startAlpha = startColor >> 24 & 0xFF;
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >> 24 & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        buffer.method_22918(mat, (float)right, (float)top, 0.0f).method_1336(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(mat, (float)left, (float)top, 0.0f).method_1336(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(mat, (float)left, (float)bottom, 0.0f).method_1336(endRed, endGreen, endBlue, endAlpha).method_1344();
        buffer.method_22918(mat, (float)right, (float)bottom, 0.0f).method_1336(endRed, endGreen, endBlue, endAlpha).method_1344();
    }
}

