/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class MaxCountFilterItem
extends StringValueFilterItem {
    public StringValueData createData(class_1799 stack) {
        return new MaxCountData(stack);
    }

    @Override
    public boolean filter(class_1799 filter, class_1799 stack) {
        MaxCountData data = (MaxCountData)this.getStringValueData(filter);
        if (data.getValue() == null) {
            return false;
        }
        int d1 = stack.method_7914();
        int d2 = ((MaxCountCheck)data.getValue()).maxCount;
        switch (((MaxCountCheck)data.getValue()).mode) {
            case 1: {
                return d1 >= d2;
            }
            case 2: {
                return d1 <= d2;
            }
            case 3: {
                return d1 > d2;
            }
            case 4: {
                return d1 < d2;
            }
        }
        return d1 == d2;
    }

    public static class MaxCountData
    extends StringValueData<MaxCountCheck> {
        public MaxCountData(class_1799 is) {
            super(is);
        }

        @Override
        @Nullable
        protected MaxCountCheck fromString(String s) {
            s = s.replaceAll("\\s", "");
            try {
                MaxCountCheck check = new MaxCountCheck();
                if (s.startsWith(">=")) {
                    check.mode = 1;
                    s = s.substring(2);
                } else if (s.startsWith("<=")) {
                    check.mode = 2;
                    s = s.substring(2);
                } else if (s.startsWith(">")) {
                    check.mode = 3;
                    s = s.substring(1);
                } else if (s.startsWith("<")) {
                    check.mode = 4;
                    s = s.substring(1);
                }
                check.maxCount = Integer.parseInt(s);
                return check;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        protected String toString(MaxCountCheck value) {
            if (value == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            switch (value.mode) {
                case 1: {
                    builder.append(">=");
                    break;
                }
                case 2: {
                    builder.append("<=");
                    break;
                }
                case 3: {
                    builder.append(">");
                    break;
                }
                case 4: {
                    builder.append("<");
                }
            }
            builder.append(value.maxCount);
            return builder.toString();
        }
    }

    public static class MaxCountCheck {
        public int mode;
        public int maxCount;
    }
}

