/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams;

import com.mojang.brigadier.CommandDispatcher;
import dev.ftb.mods.ftbteams.FTBTeamsCommon;
import dev.ftb.mods.ftbteams.client.FTBTeamsClient;
import dev.ftb.mods.ftbteams.data.FTBTeamsCommands;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import dev.ftb.mods.ftbteams.property.TeamPropertyArgument;
import java.util.function.Consumer;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.utils.EnvExecutor;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBTeams {
    public static final String MOD_ID = "ftbteams";
    public static final String MOD_NAME = "FTB Teams";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Teams");
    public static FTBTeamsCommon PROXY;

    public FTBTeams() {
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(this::registerCommands);
        LifecycleEvent.SERVER_STOPPED.register(this::serverStopped);
        LifecycleEvent.SERVER_WORLD_SAVE.register(this::worldSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        PlayerEvent.PLAYER_JOIN.register(this::playerLoggedIn);
        PlayerEvent.PLAYER_QUIT.register(this::playerLoggedOut);
        FTBTeamsNet.init();
        PROXY = (FTBTeamsCommon)EnvExecutor.getEnvSpecific(() -> FTBTeamsClient::new, () -> FTBTeamsCommon::new);
    }

    public void setup() {
        class_2316.method_10017((String)"ftbteams:team", TeamArgument.class, (class_2314)new class_2319(TeamArgument::create));
        class_2316.method_10017((String)"ftbteams:team_property", TeamPropertyArgument.class, (class_2314)new class_2319(TeamPropertyArgument::create));
    }

    private void serverAboutToStart(MinecraftServer server) {
        TeamManager.INSTANCE = new TeamManager(server);
        ((Consumer)TeamManagerEvent.CREATED.invoker()).accept(new TeamManagerEvent(TeamManager.INSTANCE));
        TeamManager.INSTANCE.load();
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 selection) {
        new FTBTeamsCommands().register(dispatcher);
    }

    private void serverStopped(MinecraftServer server) {
        ((Consumer)TeamManagerEvent.DESTROYED.invoker()).accept(new TeamManagerEvent(TeamManager.INSTANCE));
        TeamManager.INSTANCE = null;
    }

    private void worldSaved(class_3218 level) {
        if (TeamManager.INSTANCE != null) {
            TeamManager.INSTANCE.saveNow();
        }
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add(TeamBase.DISPLAY_NAME);
        event.add(TeamBase.DESCRIPTION);
        event.add(TeamBase.COLOR);
        event.add(TeamBase.FREE_TO_JOIN);
    }

    private void playerLoggedIn(class_3222 player) {
        if (TeamManager.INSTANCE != null) {
            TeamManager.INSTANCE.playerLoggedIn(player, player.method_5667(), player.method_5820());
        }
    }

    private void playerLoggedOut(class_3222 player) {
        if (TeamManager.INSTANCE != null) {
            TeamManager.INSTANCE.playerLoggedOut(player);
        }
    }
}

