/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.UpdatePresenceMessage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PlayerTeam
extends Team {
    public String playerName = "";
    public boolean online = false;
    public Team actualTeam = this;

    public PlayerTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PLAYER;
    }

    @Override
    protected void serializeExtraNBT(class_2487 tag) {
        tag.method_10582("player_name", this.playerName);
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.playerName = tag.method_10558("player_name");
    }

    @Nullable
    public class_3222 getPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.server, this.id);
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (playerId.equals(this.id)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    @Override
    public List<class_3222> getOnlineMembers() {
        class_3222 p = this.getPlayer();
        return p == null ? Collections.emptyList() : Collections.singletonList(p);
    }

    public void updatePresence() {
        new UpdatePresenceMessage(new KnownClientPlayer(this)).sendToAll(this.manager.server);
    }

    public void createParty(class_3222 player, String name, String description, int color, Set<GameProfile> invited) {
        try {
            PartyTeam team = (PartyTeam)this.manager.createParty(player, name).getRight();
            team.setProperty(DESCRIPTION, description);
            team.setProperty(COLOR, Color4I.rgb((int)color));
            team.invite(player, invited);
            this.manager.syncAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasTeam() {
        return this.actualTeam != this;
    }
}

