/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.net.SendMessageResponseMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class Team
extends TeamBase {
    public final TeamManager manager;
    boolean shouldSave;

    public Team(TeamManager m) {
        this.id = class_156.field_25140;
        this.manager = m;
        this.properties.collect();
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    @Override
    public void save() {
        this.shouldSave = true;
        this.manager.nameMap = null;
    }

    public List<class_3222> getOnlineRanked(TeamRank rank) {
        ArrayList<class_3222> list = new ArrayList<class_3222>();
        for (UUID id : this.getRanked(rank).keySet()) {
            class_3222 player = FTBTUtils.getPlayerByUUID(this.manager.server, id);
            if (player == null) continue;
            list.add(player);
        }
        return list;
    }

    public List<class_3222> getOnlineMembers() {
        return this.getOnlineRanked(TeamRank.MEMBER);
    }

    void created(class_3222 p) {
        ((Consumer)TeamEvent.CREATED.invoker()).accept(new TeamCreatedEvent(this, p));
        this.save();
        this.manager.save();
    }

    void updateCommands(class_3222 player) {
        this.manager.server.method_3760().method_14576(player);
    }

    void changedTeam(@Nullable Team prev, UUID player, @Nullable class_3222 p, boolean deleted) {
        ((Consumer)TeamEvent.PLAYER_CHANGED.invoker()).accept(new PlayerChangedTeamEvent(this, prev, player, p));
        if (prev instanceof PartyTeam) {
            ((Consumer)TeamEvent.PLAYER_LEFT_PARTY.invoker()).accept(new PlayerLeftPartyTeamEvent(prev, (PlayerTeam)this, player, p, deleted));
        } else if (prev instanceof PlayerTeam && p != null) {
            ((Consumer)TeamEvent.PLAYER_JOINED_PARTY.invoker()).accept(new PlayerJoinedPartyTeamEvent(this, (PlayerTeam)prev, p));
        }
        if (deleted && prev != null) {
            ((Consumer)TeamEvent.DELETED.invoker()).accept(new TeamEvent(prev));
        }
        if (p != null) {
            this.updateCommands(p);
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.method_10582("id", this.getId().toString());
        tag.method_10582("type", this.getType().method_15434());
        this.serializeExtraNBT((class_2487)tag);
        SNBTCompoundTag ranksNBT = new SNBTCompoundTag();
        for (Map.Entry entry : this.ranks.entrySet()) {
            ranksNBT.method_10582(((UUID)entry.getKey()).toString(), ((TeamRank)((Object)entry.getValue())).method_15434());
        }
        tag.method_10566("ranks", (class_2520)ranksNBT);
        tag.method_10566("properties", (class_2520)this.properties.write((class_2487)new SNBTCompoundTag()));
        class_2499 messageHistoryTag = new class_2499();
        for (TeamMessage m : this.messageHistory) {
            SNBTCompoundTag mt = new SNBTCompoundTag();
            mt.singleLine();
            mt.method_10582("from", m.sender.toString());
            mt.method_10544("date", m.date);
            mt.method_10582("text", class_2561.class_2562.method_10867((class_2561)m.text));
            messageHistoryTag.add((Object)mt);
        }
        tag.method_10566("message_history", (class_2520)messageHistoryTag);
        ((Consumer)TeamEvent.SAVED.invoker()).accept(new TeamEvent(this));
        tag.method_10566("extra", (class_2520)this.extraData);
        return tag;
    }

    protected void serializeExtraNBT(class_2487 tag) {
    }

    public void deserializeNBT(class_2487 tag) {
        this.ranks.clear();
        class_2487 ranksNBT = tag.method_10562("ranks");
        for (String s : ranksNBT.method_10541()) {
            this.ranks.put(UUID.fromString(s), (TeamRank)((Object)TeamRank.NAME_MAP.get(ranksNBT.method_10558(s))));
        }
        this.properties.read(tag.method_10562("properties"));
        this.extraData = tag.method_10562("extra");
        this.messageHistory.clear();
        class_2499 messageHistoryTag = tag.method_10554("message_history", 10);
        for (int i = 0; i < messageHistoryTag.size(); ++i) {
            class_2487 mt = messageHistoryTag.method_10602(i);
            this.messageHistory.add(new TeamMessage(UUID.fromString(mt.method_10558("from")), mt.method_10537("date"), (class_2561)class_2561.class_2562.method_10877((String)mt.method_10558("text"))));
        }
        ((Consumer)TeamEvent.LOADED.invoker()).accept(new TeamEvent(this));
    }

    public int settings(class_2168 source, TeamProperty key, String value) throws CommandSyntaxException {
        if (value.isEmpty()) {
            class_2588 keyc = new class_2588("ftbteamsconfig." + key.id.method_12836() + "." + key.id.method_12832());
            keyc.method_27692(class_124.field_1054);
            class_2585 valuec = new class_2585(key.toString(this.getProperty(key)));
            valuec.method_27692(class_124.field_1075);
            source.method_9226((class_2561)new class_2585("").method_10852((class_2561)keyc).method_27693(" is set to ").method_10852((class_2561)valuec), true);
        } else {
            Optional optional = key.fromString(value);
            if (!optional.isPresent()) {
                source.method_9226((class_2561)new class_2585("Failed to parse value!"), true);
                return 0;
            }
            TeamProperties old = this.properties.copy();
            this.setProperty(key, optional.get());
            class_2588 keyc = new class_2588("ftbteamsconfig." + key.id.method_12836() + "." + key.id.method_12832());
            keyc.method_27692(class_124.field_1054);
            class_2585 valuec = new class_2585(value);
            valuec.method_27692(class_124.field_1075);
            source.method_9226((class_2561)new class_2585("Set ").method_10852((class_2561)keyc).method_27693(" to ").method_10852((class_2561)valuec), true);
            ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, old));
        }
        return 1;
    }

    @Deprecated
    public int denyInvite(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (this.isInvited(player.method_5667()) && !this.isMember(player.method_5667())) {
            this.ranks.put(player.method_5667(), TeamRank.ALLY);
            source.method_9226((class_2561)new class_2585("Invite denied"), true);
            this.save();
            this.manager.syncAll();
        }
        return 1;
    }

    @Deprecated
    public int info(class_2168 source) throws CommandSyntaxException {
        source.method_9226(class_2585.field_24366, false);
        class_2585 infoComponent = new class_2585("");
        infoComponent.method_10866().method_10982(Boolean.valueOf(true));
        infoComponent.method_27693("== ");
        infoComponent.method_10852(this.getName());
        infoComponent.method_27693(" ==");
        source.method_9226((class_2561)infoComponent, false);
        source.method_9226((class_2561)new class_2588("ftbteams.info.id", new Object[]{new class_2585(this.getId().toString()).method_27692(class_124.field_1054)}), false);
        source.method_9226((class_2561)new class_2588("ftbteams.info.short_id", new Object[]{new class_2585(this.getStringID()).method_27692(class_124.field_1054)}).method_27693(" [" + this.getType().method_15434() + "]"), false);
        if (this.getOwner().equals(class_156.field_25140)) {
            source.method_9226((class_2561)new class_2588("ftbteams.info.owner", new Object[]{new class_2588("ftbteams.info.owner.none")}), false);
        } else {
            source.method_9226((class_2561)new class_2588("ftbteams.info.owner", new Object[]{this.manager.getName(this.getOwner())}), false);
        }
        source.method_9226((class_2561)new class_2588("ftbteams.info.members"), false);
        if (this.getMembers().isEmpty()) {
            source.method_9226((class_2561)new class_2585("- ").method_10852((class_2561)new class_2588("ftbteams.info.members.none")), false);
        } else {
            for (UUID member : this.getMembers()) {
                source.method_9226((class_2561)new class_2585("- ").method_10852(this.manager.getName(member)), false);
            }
        }
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(this, source));
        return 1;
    }

    public UUID getOwner() {
        return class_156.field_25140;
    }

    public int msg(class_3222 player, String message) throws CommandSyntaxException {
        this.sendMessage(player.method_5667(), TextComponentUtils.withLinks((String)message));
        return 1;
    }

    public void sendMessage(UUID from, class_2561 text) {
        this.messageHistory.add(new TeamMessage(from, System.currentTimeMillis(), text));
        if (this.messageHistory.size() > 1000) {
            this.messageHistory.remove(0);
        }
        class_2585 component = new class_2585("<");
        component.method_10852(this.manager.getName(from));
        component.method_27693(" @");
        component.method_10852(this.getName());
        component.method_27693("> ");
        component.method_10852(text);
        for (class_3222 p : this.getOnlineMembers()) {
            p.method_7353((class_2561)component, false);
            new SendMessageResponseMessage(from, text).sendTo(p);
        }
        this.save();
    }
}

