/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuestsCommon;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.architectury.registry.ReloadListeners;
import me.shedaniel.architectury.registry.RenderTypes;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2633;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient
extends FTBQuestsCommon {
    public static class_304 KEY_QUESTS;

    @Override
    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::setup);
        ReloadListeners.registerReloadListener((class_3264)class_3264.field_14188, (class_3302)new QuestFileCacheReloader());
        ReloadListeners.registerReloadListener((class_3264)class_3264.field_14188, (class_3302)new ThemeLoader());
        new FTBQuestsClientEventHandler().init();
    }

    private void setup(class_310 minecraft) {
        KEY_QUESTS = new class_304("key.ftbquests.quests", class_3675.class_307.field_1668, -1, "key.categories.ftbquests");
        KeyBindings.registerKeyBinding((class_304)KEY_QUESTS);
        RenderTypes.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.BARRIER.get()});
        RenderTypes.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.STAGE_BARRIER.get()});
        this.setTaskGuiProviders();
        this.setRewardGuiProviders();
    }

    @Override
    @Nullable
    public QuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    @Override
    public QuestFile getQuestFile(boolean isClient) {
        if (isClient) {
            QuestFile f = this.getClientQuestFile();
            if (f == null) {
                throw new NullPointerException("Client quest file not loaded!");
            }
            return f;
        }
        return ServerQuestFile.INSTANCE;
    }

    @Override
    public void setTaskGuiProviders() {
        TaskTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            c.defaultValue = class_1799.field_8037;
            c.value = class_1799.field_8037;
            new SelectItemStackScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(quest);
                    itemTask.item = ((class_1799)c.value).method_7972();
                    itemTask.item.method_7939(1);
                    itemTask.count = ((class_1799)c.value).method_7947();
                    callback.accept(itemTask);
                }
            }).openGui();
        });
        TaskTypes.CHECKMARK.setGuiProvider((gui, quest, callback) -> {
            StringConfig c = new StringConfig(null);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                if (accepted) {
                    CheckmarkTask checkmarkTask = new CheckmarkTask(quest);
                    checkmarkTask.title = (String)c.value;
                    callback.accept(checkmarkTask);
                }
                gui.run();
            });
        });
        TaskTypes.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(quest);
            task.dimension = class_310.method_1551().field_1687.method_27983();
            callback.accept(task);
        });
        TaskTypes.LOCATION.setGuiProvider((gui, quest, callback) -> {
            class_2586 tileEntity;
            LocationTask task = new LocationTask(quest);
            class_310 mc = class_310.method_1551();
            if (mc.field_1765 instanceof class_3965 && (tileEntity = mc.field_1687.method_8321(((class_3965)mc.field_1765).method_17777())) instanceof class_2633) {
                class_2338 pos = ((class_2633)tileEntity).method_11359();
                class_2338 size = ((class_2633)tileEntity).method_11349();
                task.dimension = mc.field_1687.method_27983();
                task.x = pos.method_10263() + tileEntity.method_11016().method_10263();
                task.y = pos.method_10264() + tileEntity.method_11016().method_10264();
                task.z = pos.method_10260() + tileEntity.method_11016().method_10260();
                task.w = Math.max(1, size.method_10263());
                task.h = Math.max(1, size.method_10264());
                task.d = Math.max(1, size.method_10260());
                callback.accept(task);
                return;
            }
            ConfigGroup group = new ConfigGroup("ftbquests");
            task.getConfig(task.createSubGroup(group));
            group.savedCallback = accepted -> {
                gui.run();
                if (accepted) {
                    callback.accept(task);
                }
            };
            new EditConfigScreen(group).openGui();
        });
    }

    @Override
    public void setRewardGuiProviders() {
        RewardTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            c.defaultValue = class_1799.field_8037;
            c.value = class_1799.field_8037;
            new SelectItemStackScreen(c, accepted -> {
                if (accepted) {
                    class_1799 copy = ((class_1799)c.value).method_7972();
                    copy.method_7939(1);
                    ItemReward reward = new ItemReward(quest, copy);
                    reward.count = ((class_1799)c.value).method_7947();
                    callback.accept(reward);
                }
                gui.run();
            }).openGui();
        });
        RewardTypes.XP.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)100, (Object)100, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
        RewardTypes.XP_LEVELS.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)5, (Object)5, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
    }

    @Override
    public class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public boolean isClientDataLoaded() {
        return ClientQuestFile.INSTANCE != null;
    }

    @Override
    public TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.self;
    }

    @Override
    public QuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    @Override
    public void openGui() {
        ClientQuestFile.INSTANCE.openQuestGui();
    }

    @Override
    public void openCustomIconGui(class_1657 player, class_1268 hand) {
        ImageConfig config = new ImageConfig();
        config.onClicked(MouseButton.LEFT, b -> {
            if (b) {
                if (((String)config.value).isEmpty()) {
                    player.method_5998(hand).method_7983("Icon");
                } else {
                    player.method_5998(hand).method_7959("Icon", (class_2520)class_2519.method_23256((String)((String)config.value)));
                }
                new SetCustomImageMessage(hand, (String)config.value).sendToServer();
            }
            class_310.method_1551().method_1507(null);
        });
    }
}

