/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.command.QuestObjectArgument;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.util.FileUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.class_1297;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsCommands {
    private static final SimpleCommandExceptionType NO_INVENTORY = new SimpleCommandExceptionType((Message)new class_2588("commands.ftbquests.command.error.no_inventory"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftbquests").requires(s -> s.method_9211().method_3724() || s.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"editing_mode").executes(c -> FTBQuestsCommands.editingMode((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.editingMode((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> FTBQuestsCommands.editingMode((class_2168)c.getSource(), class_2186.method_9315((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"locked").executes(c -> FTBQuestsCommands.locked((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.locked((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> FTBQuestsCommands.locked((class_2168)c.getSource(), class_2186.method_9315((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(class_2170.method_9247((String)"delete_empty_reward_tables").executes(context -> FTBQuestsCommands.deleteEmptyRewardTables((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"change_progress").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"quest_object", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            Collection players = class_2186.method_9312((CommandContext)ctx, (String)"players");
            QuestObjectBase questObject = (QuestObjectBase)ctx.getArgument("quest_object", QuestObjectBase.class);
            return FTBQuestsCommands.changeProgress((class_2168)ctx.getSource(), players, true, questObject);
        })))).then(class_2170.method_9247((String)"complete").then(class_2170.method_9244((String)"quest_object", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            Collection players = class_2186.method_9312((CommandContext)ctx, (String)"players");
            QuestObjectBase questObject = (QuestObjectBase)ctx.getArgument("quest_object", QuestObjectBase.class);
            return FTBQuestsCommands.changeProgress((class_2168)ctx.getSource(), players, false, questObject);
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export_reward_table_to_chest").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"reward_table", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            QuestObjectBase table = (QuestObjectBase)ctx.getArgument("reward_table", QuestObjectBase.class);
            if (!(table instanceof RewardTable)) {
                throw QuestObjectArgument.NO_OBJECT.create((Object)table.getCodeString());
            }
            return FTBQuestsCommands.exportRewards((class_2168)ctx.getSource(), (RewardTable)table, null);
        })).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            QuestObjectBase table = (QuestObjectBase)ctx.getArgument("reward_table", QuestObjectBase.class);
            class_2338 pos = class_2262.method_9697((CommandContext)ctx, (String)"pos");
            if (!(table instanceof RewardTable)) {
                throw QuestObjectArgument.NO_OBJECT.create((Object)table.getCodeString());
            }
            return FTBQuestsCommands.exportRewards((class_2168)ctx.getSource(), (RewardTable)table, pos);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"import_reward_table_from_chest").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return FTBQuestsCommands.importRewards((class_2168)ctx.getSource(), name, null);
        })).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            class_2338 pos = class_2262.method_9697((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.importRewards((class_2168)ctx.getSource(), name, pos);
        }))))).then(class_2170.method_9247((String)"generate_chapter_with_all_items_in_game").executes(context -> FTBQuestsCommands.generateAllItemChapter((class_2168)context.getSource()))));
    }

    private static int exportRewards(class_2168 source, RewardTable table, class_2338 pos) throws CommandSyntaxException {
        class_2586 be;
        class_3222 player = source.method_9207();
        class_3218 level = source.method_9225();
        if (pos == null) {
            pos = new class_2338(player.method_5745(10.0, 1.0f, false).method_17784());
        }
        if (!((be = level.method_8321(pos)) instanceof class_2624)) {
            throw NO_INVENTORY.create();
        }
        class_2624 container = (class_2624)be;
        container.method_5448();
        int s = 0;
        for (WeightedReward reward : table.rewards) {
            if (s >= container.method_5439()) {
                source.method_9226((class_2561)new class_2588("commands.ftbquests.command.feedback.table_too_many_items", new Object[]{table.getTitle()}), false);
                return 0;
            }
            if (!(reward.reward instanceof ItemReward)) continue;
            container.method_5447(s++, ((ItemReward)reward.reward).item);
        }
        source.method_9226((class_2561)new class_2588("commands.ftbquests.command.feedback.table_imported", new Object[]{table.getTitle(), table.rewards.size()}), false);
        return 1;
    }

    private static int importRewards(class_2168 source, String name, class_2338 pos) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3218 level = source.method_9225();
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (pos == null) {
            pos = new class_2338(player.method_5745(10.0, 1.0f, false).method_17784());
        }
        RewardTable table = new RewardTable(file);
        table.id = file.newID();
        table.title = name;
        table.icon = class_1802.field_8106.method_7854();
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof class_2624)) {
            throw NO_INVENTORY.create();
        }
        class_2624 container = (class_2624)be;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            table.rewards.add(new WeightedReward(new ItemReward(table.fakeQuest, stack), 1));
        }
        file.rewardTables.add(table);
        file.save();
        new CreateObjectResponseMessage(table, null).sendToAll(level.method_8503());
        source.method_9226((class_2561)new class_2588("commands.ftbquests.command.feedback.table_imported", new Object[]{name, table.rewards.size()}), false);
        return 1;
    }

    private static int editingMode(class_2168 source, class_3222 player, @Nullable Boolean canEdit) {
        TeamData data = ServerQuestFile.INSTANCE.getData((class_1297)player);
        if (canEdit == null) {
            canEdit = !data.getCanEdit();
        }
        data.setCanEdit(canEdit);
        if (canEdit.booleanValue()) {
            source.method_9226((class_2561)new class_2588("commands.ftbquests.editing_mode.enabled", new Object[]{player.method_5476()}), true);
        } else {
            source.method_9226((class_2561)new class_2588("commands.ftbquests.editing_mode.disabled", new Object[]{player.method_5476()}), true);
        }
        return 1;
    }

    private static int locked(class_2168 source, class_3222 player, @Nullable Boolean locked) {
        TeamData data = ServerQuestFile.INSTANCE.getData((class_1297)player);
        if (locked == null) {
            locked = !data.isLocked();
        }
        data.setLocked(locked);
        if (locked.booleanValue()) {
            source.method_9226((class_2561)new class_2588("commands.ftbquests.locked.enabled", new Object[]{player.method_5476()}), true);
        } else {
            source.method_9226((class_2561)new class_2588("commands.ftbquests.locked.disabled", new Object[]{player.method_5476()}), true);
        }
        return 1;
    }

    private static int changeProgress(class_2168 source, Collection<class_3222> players, boolean reset, QuestObjectBase questObject) {
        ProgressChange progressChange = new ProgressChange(ServerQuestFile.INSTANCE);
        progressChange.origin = questObject;
        progressChange.reset = reset;
        for (class_3222 player : players) {
            progressChange.player = player.method_5667();
            questObject.forceProgress(ServerQuestFile.INSTANCE.getData((class_1297)player), progressChange);
        }
        source.method_9226((class_2561)new class_2588("commands.ftbquests.change_progress.text"), true);
        return 1;
    }

    private static int deleteEmptyRewardTables(class_2168 source) {
        int del = 0;
        for (RewardTable table : ServerQuestFile.INSTANCE.rewardTables) {
            if (!table.rewards.isEmpty()) continue;
            ++del;
            table.invalid = true;
            FileUtils.delete(ServerQuestFile.INSTANCE.getFolder().resolve(table.getPath()).toFile());
            new DeleteObjectResponseMessage(table.id).sendToAll(source.method_9211());
        }
        ServerQuestFile.INSTANCE.rewardTables.removeIf(rewardTable -> rewardTable.invalid);
        ServerQuestFile.INSTANCE.refreshIDMap();
        ServerQuestFile.INSTANCE.save();
        source.method_9226((class_2561)new class_2585("Deleted " + del + " empty tables"), false);
        return 1;
    }

    private static int generateAllItemChapter(class_2168 source) {
        class_2371 nonNullList = class_2371.method_10211();
        for (Map.Entry entry : class_2378.field_11142.method_29722()) {
            class_1792 item = (class_1792)entry.getValue();
            try {
                int s = nonNullList.size();
                item.method_7850(class_1761.field_7915, nonNullList);
                if (s != nonNullList.size()) continue;
                nonNullList.add((Object)new class_1799((class_1935)item));
            }
            catch (Throwable ex) {
                FTBQuests.LOGGER.warn("Failed to get items from " + entry.getKey() + ": " + ex);
            }
        }
        Chapter chapter = new Chapter(ServerQuestFile.INSTANCE, ServerQuestFile.INSTANCE.defaultChapterGroup);
        chapter.id = chapter.file.newID();
        chapter.onCreated();
        chapter.title = "Generated chapter of all items in search creative tab [" + nonNullList.size() + "]";
        chapter.icon = new class_1799((class_1935)class_1802.field_8251);
        chapter.defaultQuestShape = "rsquare";
        new CreateObjectResponseMessage(chapter, null).sendToAll(source.method_9211());
        List list = nonNullList.stream().filter(stack -> !stack.method_7960() && Registries.getId((Object)stack.method_7909(), (class_5321)class_2378.field_25108) != null).sorted(Comparator.comparing(a -> Registries.getId((Object)a.method_7909(), (class_5321)class_2378.field_25108))).collect(Collectors.toList());
        FTBQuests.LOGGER.info("Found " + nonNullList.size() + " items in total, chapter ID: " + chapter);
        if (list.isEmpty()) {
            return 0;
        }
        int col = 0;
        int row = 0;
        String modid = Registries.getId((Object)((class_1799)list.get(0)).method_7909(), (class_5321)class_2378.field_25108).method_12836();
        for (class_1799 stack2 : list) {
            class_2960 id = Registries.getId((Object)stack2.method_7909(), (class_5321)class_2378.field_25108);
            if (!modid.equals(id.method_12836())) {
                modid = id.method_12836();
                col = 0;
                row += 2;
            } else if (col >= 40) {
                col = 0;
                ++row;
            }
            Quest quest = new Quest(chapter);
            quest.id = chapter.file.newID();
            quest.onCreated();
            quest.x = col;
            quest.y = row;
            quest.subtitle = stack2.method_7953(new class_2487()).toString();
            new CreateObjectResponseMessage(quest, null).sendToAll(source.method_9211());
            ItemTask task = new ItemTask(quest);
            task.id = chapter.file.newID();
            task.onCreated();
            task.consumeItems = Tristate.TRUE;
            task.item = stack2;
            class_2487 extra = new class_2487();
            extra.method_10582("type", task.getType().getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(source.method_9211());
            ++col;
        }
        ServerQuestFile.INSTANCE.save();
        ServerQuestFile.INSTANCE.saveNow();
        source.method_9226((class_2561)new class_2585("Done!"), false);
        return 1;
    }
}

