/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.events;

import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.Date;
import java.util.List;
import me.shedaniel.architectury.event.Event;
import me.shedaniel.architectury.event.EventActor;
import me.shedaniel.architectury.event.EventFactory;
import net.minecraft.class_3222;

public class ObjectStartedEvent<T extends QuestObject> {
    public static final Event<EventActor<ObjectStartedEvent<?>>> GENERIC = EventFactory.createEventActorLoop((Object[])new ObjectStartedEvent[0]);
    public static final Event<EventActor<FileEvent>> FILE = EventFactory.createEventActorLoop((Object[])new FileEvent[0]);
    public static final Event<EventActor<ChapterEvent>> CHAPTER = EventFactory.createEventActorLoop((Object[])new ChapterEvent[0]);
    public static final Event<EventActor<QuestEvent>> QUEST = EventFactory.createEventActorLoop((Object[])new QuestEvent[0]);
    public static final Event<EventActor<TaskEvent>> TASK = EventFactory.createEventActorLoop((Object[])new TaskEvent[0]);
    private final QuestProgressEventData<T> data;

    private ObjectStartedEvent(QuestProgressEventData<T> d) {
        this.data = d;
    }

    public boolean isCancelable() {
        return true;
    }

    public Date getTime() {
        return this.data.time;
    }

    public TeamData getData() {
        return this.data.teamData;
    }

    public T getObject() {
        return this.data.object;
    }

    public List<class_3222> getOnlineMembers() {
        return this.data.onlineMembers;
    }

    public List<class_3222> getNotifiedPlayers() {
        return this.data.notifiedPlayers;
    }

    @Deprecated
    public TeamData getTeam() {
        return this.getData();
    }

    static {
        FILE.register(event -> ((EventActor)GENERIC.invoker()).act(event));
        CHAPTER.register(event -> ((EventActor)GENERIC.invoker()).act(event));
        QUEST.register(event -> ((EventActor)GENERIC.invoker()).act(event));
        TASK.register(event -> ((EventActor)GENERIC.invoker()).act(event));
    }

    public static class TaskEvent
    extends ObjectStartedEvent<Task> {
        public TaskEvent(QuestProgressEventData<Task> d) {
            super(d);
        }

        public Task getTask() {
            return (Task)this.getObject();
        }
    }

    public static class QuestEvent
    extends ObjectStartedEvent<Quest> {
        public QuestEvent(QuestProgressEventData<Quest> d) {
            super(d);
        }

        public Quest getQuest() {
            return (Quest)this.getObject();
        }
    }

    public static class ChapterEvent
    extends ObjectStartedEvent<Chapter> {
        public ChapterEvent(QuestProgressEventData<Chapter> d) {
            super(d);
        }

        public Chapter getChapter() {
            return (Chapter)this.getObject();
        }
    }

    public static class FileEvent
    extends ObjectStartedEvent<QuestFile> {
        public FileEvent(QuestProgressEventData<QuestFile> d) {
            super(d);
        }

        public QuestFile getFile() {
            return (QuestFile)this.getObject();
        }
    }
}

