/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class EditRewardTableScreen
extends ButtonListBaseScreen {
    private final RewardTable originalTable;
    private final RewardTable rewardTable;
    private final Runnable callback;

    public EditRewardTableScreen(RewardTable r, Runnable c) {
        this.originalTable = r;
        this.rewardTable = new RewardTable(this.originalTable.file);
        class_2487 nbt = new class_2487();
        this.originalTable.writeData(nbt);
        this.rewardTable.readData(nbt);
        this.callback = c;
        this.setTitle((class_2561)new class_2588("ftbquests.reward_table"));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        panel.add((Widget)new RewardTableSettingsButton(panel));
        panel.add((Widget)new SaveRewardTableButton(panel));
        panel.add((Widget)new AddWeightedRewardButton(panel));
        panel.add((Widget)new VerticalSpaceWidget(panel, 1));
        for (WeightedReward r : this.rewardTable.rewards) {
            panel.add((Widget)new WeightedRewardButton(panel, r));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class WeightedRewardButton
    extends SimpleTextButton {
        private final WeightedReward reward;

        private WeightedRewardButton(Panel panel, WeightedReward r) {
            super(panel, r.reward.getTitle(), r.reward.getIcon());
            this.reward = r;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.reward.reward.addMouseOverText(list);
            list.add((class_2561)new class_2588("ftbquests.reward_table.weight").method_27693(": " + this.reward.weight).method_10852((class_2561)new class_2585(" [" + WeightedReward.chanceString(this.reward.weight, EditRewardTableScreen.this.rewardTable.getTotalWeight(true)) + "]").method_27692(class_124.field_1063)));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)new class_2588("selectServer.edit"), Icons.SETTINGS, () -> {
                ConfigGroup group = new ConfigGroup("ftbquests");
                this.reward.reward.getConfig(this.reward.reward.createSubGroup(group));
                group.savedCallback = accepted -> this.run();
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.reward_table.set_weight"), Icons.SETTINGS, () -> {
                DoubleConfig c = new DoubleConfig(0.0, Double.POSITIVE_INFINITY);
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)this.reward.weight, (Object)1.0, accepted -> {
                    if (accepted) {
                        this.reward.weight = ((Double)c.value).intValue();
                        if ((Double)c.value < 1.0) {
                            for (WeightedReward reward : ((EditRewardTableScreen)EditRewardTableScreen.this).rewardTable.rewards) {
                                reward.weight = (int)((double)reward.weight / (Double)c.value);
                            }
                            this.reward.weight = 1;
                        }
                    }
                    this.run();
                });
            }));
            contextMenu.add(new ContextMenuItem((class_2561)new class_2588("selectServer.delete"), Icons.REMOVE, () -> {
                ((EditRewardTableScreen)EditRewardTableScreen.this).rewardTable.rewards.remove(this.reward);
                EditRewardTableScreen.this.refreshWidgets();
            }).setYesNo((class_2561)new class_2588("delete_item", new Object[]{this.reward.reward.getTitle()})));
            EditRewardTableScreen.this.openContextMenu(contextMenu);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.reward.reward.getIngredient();
        }
    }

    private class AddWeightedRewardButton
    extends SimpleTextButton {
        private AddWeightedRewardButton(Panel panel) {
            super(panel, (class_2561)new class_2588("gui.add"), Icons.ADD);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (RewardType type : RewardTypes.TYPES.values()) {
                if (type.getExcludeFromListRewards()) continue;
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui((Runnable)((Object)this), ((EditRewardTableScreen)EditRewardTableScreen.this).rewardTable.fakeQuest, reward -> {
                        ((EditRewardTableScreen)EditRewardTableScreen.this).rewardTable.rewards.add(new WeightedReward((Reward)reward, 1));
                        this.openGui();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    private class SaveRewardTableButton
    extends SimpleTextButton {
        private SaveRewardTableButton(Panel panel) {
            super(panel, (class_2561)new class_2588("gui.accept"), Icons.ACCEPT);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            class_2487 nbt = new class_2487();
            EditRewardTableScreen.this.rewardTable.writeData(nbt);
            EditRewardTableScreen.this.originalTable.readData(nbt);
            EditRewardTableScreen.this.callback.run();
        }
    }

    private class RewardTableSettingsButton
    extends SimpleTextButton {
        private RewardTableSettingsButton(Panel panel) {
            super(panel, (class_2561)new class_2588("gui.settings"), Icons.SETTINGS);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigGroup group = new ConfigGroup("ftbquests");
            EditRewardTableScreen.this.rewardTable.getConfig(EditRewardTableScreen.this.rewardTable.createSubGroup(group));
            group.savedCallback = accepted -> this.run();
            new EditConfigScreen(group).openGui();
        }
    }
}

