/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4587;

public class RewardTablesScreen
extends ButtonListBaseScreen {
    public RewardTablesScreen() {
        this.setTitle((class_2561)new class_2588("ftbquests.reward_tables"));
        this.setHasSearchBox(true);
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        SimpleTextButton button = new SimpleTextButton(panel, (class_2561)new class_2588("gui.add"), Icons.ADD){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                StringConfig c = new StringConfig();
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    if (accepted) {
                        RewardTable table = new RewardTable(ClientQuestFile.INSTANCE);
                        table.title = (String)c.value;
                        new CreateObjectMessage(table, null).sendToServer();
                    }
                    this.openGui();
                });
            }
        };
        button.setHeight(14);
        panel.add((Widget)button);
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            panel.add((Widget)new RewardTableButton(panel, table));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class RewardTableButton
    extends SimpleTextButton {
        private final RewardTable table;

        public RewardTableButton(Panel panel, RewardTable t) {
            super(panel, t.getTitle(), t.getIcon());
            this.table = t;
            this.setHeight(14);
            if (this.table.lootCrate != null) {
                this.title = this.title.method_27661().method_27692(class_124.field_1054);
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (button.isLeft()) {
                this.table.onEditButtonClicked((Runnable)((Object)this));
                return;
            }
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            ClientQuestFile.INSTANCE.questScreen.addObjectMenuItems(contextMenu, (Runnable)((Object)RewardTablesScreen.this), this.table);
            contextMenu.add(new ContextMenuItem((class_2561)new class_2588("item.ftbquests.lootcrate"), Icons.ACCEPT, () -> {
                if (this.table.lootCrate == null) {
                    this.table.lootCrate = new LootCrate(this.table);
                    Matcher matcher = Pattern.compile("[^a-z0-9_]").matcher(this.table.getTitle().getString().toLowerCase());
                    Matcher matcher1 = Pattern.compile("_{2,}").matcher(matcher.replaceAll("_"));
                    switch (this.table.lootCrate.stringID = matcher1.replaceAll("_")) {
                        case "common": {
                            this.table.lootCrate.color = Color4I.rgb((int)0x92999A);
                            this.table.lootCrate.drops.passive = 350;
                            this.table.lootCrate.drops.monster = 10;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "uncommon": {
                            this.table.lootCrate.color = Color4I.rgb((int)3648105);
                            this.table.lootCrate.drops.passive = 200;
                            this.table.lootCrate.drops.monster = 90;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "rare": {
                            this.table.lootCrate.color = Color4I.rgb((int)38143);
                            this.table.lootCrate.drops.passive = 50;
                            this.table.lootCrate.drops.monster = 200;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "epic": {
                            this.table.lootCrate.color = Color4I.rgb((int)0x8000FF);
                            this.table.lootCrate.drops.passive = 9;
                            this.table.lootCrate.drops.monster = 10;
                            this.table.lootCrate.drops.boss = 10;
                            break;
                        }
                        case "legendary": {
                            this.table.lootCrate.color = Color4I.rgb((int)16761159);
                            this.table.lootCrate.glow = true;
                            this.table.lootCrate.drops.passive = 1;
                            this.table.lootCrate.drops.monster = 1;
                            this.table.lootCrate.drops.boss = 190;
                        }
                    }
                    this.title = this.table.getMutableTitle().method_27692(class_124.field_1054);
                } else {
                    this.table.lootCrate = null;
                    this.title = this.table.getTitle();
                }
                new EditObjectMessage(this.table).sendToServer();
            }){

                public void drawIcon(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
                    (((RewardTableButton)RewardTableButton.this).table.lootCrate != null ? Icons.ACCEPT : Icons.ACCEPT_GRAY).draw(matrixStack, x, y, w, h);
                }
            });
            this.getGui().openContextMenu(contextMenu);
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            int usedIn = 0;
            for (ChapterGroup group : this.table.file.chapterGroups) {
                for (Chapter chapter : group.chapters) {
                    for (Quest quest : chapter.quests) {
                        for (Reward reward : quest.rewards) {
                            if (!(reward instanceof RandomReward) || ((RandomReward)reward).table != this.table) continue;
                            ++usedIn;
                        }
                    }
                }
            }
            if (usedIn > 0) {
                list.add((class_2561)new class_2588("ftbquests.reward_table.used_in", new Object[]{usedIn}).method_27692(class_124.field_1080));
            }
            this.table.addMouseOverText(list, true, true);
        }
    }
}

