/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.gui.quests.TabButton;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;

public class EditSettingsButton
extends TabButton {
    public EditSettingsButton(Panel panel) {
        super(panel, (class_2561)new class_2588("gui.settings"), (Icon)ThemeProperties.SETTINGS_ICON.get());
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.questScreen.contextMenu != null) {
            this.questScreen.closeContextMenu();
            return;
        }
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.edit_file"), (Icon)ThemeProperties.SETTINGS_ICON.get(), () -> this.questScreen.file.onEditButtonClicked((Runnable)((Object)this))));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> ChangeProgressMessage.send(this.questScreen.file.self, this.questScreen.file, progressChange -> {
            progressChange.reset = true;
        })).setYesNo((class_2561)new class_2588("ftbquests.gui.reset_progress_q")));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), () -> ChangeProgressMessage.send(this.questScreen.file.self, this.questScreen.file, progressChange -> {
            progressChange.reset = false;
        })).setYesNo((class_2561)new class_2588("ftbquests.gui.complete_instantly_q")));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.reward_tables"), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), () -> new RewardTablesScreen().openGui()));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.save_as_file"), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), () -> {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(class_310.method_1551().field_1697, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file.toPath());
                class_2588 component = new class_2588("ftbquests.gui.saved_as_file", new Object[]{"." + file.getPath().replace(class_310.method_1551().field_1697.getCanonicalFile().getAbsolutePath(), "")});
                component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath()));
                class_310.method_1551().field_1724.method_9203((class_2561)component, class_156.field_25140);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.reload_theme"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
            class_310 mc = class_310.method_1551();
            ThemeLoader.loadTheme(mc.method_1478());
            ClientQuestFile.INSTANCE.refreshGui();
        }));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.wiki"), Icons.INFO, () -> this.handleClick("https://help.ftb.team/mods")));
        this.questScreen.openContextMenu(contextMenu);
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

