/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class ChangeProgressMessage
extends BaseC2SMessage {
    private final UUID team;
    private final ProgressChange progressChange;

    ChangeProgressMessage(class_2540 buffer) {
        this.team = buffer.method_10790();
        this.progressChange = new ProgressChange(ServerQuestFile.INSTANCE, buffer);
    }

    public ChangeProgressMessage(UUID t, ProgressChange p) {
        this.team = t;
        this.progressChange = p;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CHANGE_PROGRESS;
    }

    @Environment(value=EnvType.CLIENT)
    public static void send(TeamData team, QuestObjectBase object, Consumer<ProgressChange> progressChange) {
        if (team.isLocked()) {
            return;
        }
        ProgressChange change = new ProgressChange(team.file);
        change.origin = object;
        change.player = class_310.method_1551().field_1724.method_5667();
        progressChange.accept(change);
        new ChangeProgressMessage(team.uuid, change).sendToServer();
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.team);
        this.progressChange.write(buffer);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (NetUtils.canEdit(context) && this.progressChange.origin != null) {
            TeamData t = ServerQuestFile.INSTANCE.getData(this.team);
            this.progressChange.origin.forceProgressRaw(t, this.progressChange);
        }
    }
}

