/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.DependencyDepthException;
import dev.ftb.mods.ftbquests.quest.DependencyLoopException;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.shedaniel.architectury.event.EventActor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public final class Chapter
extends QuestObject {
    public final QuestFile file;
    public ChapterGroup group;
    public String filename;
    public final List<Quest> quests;
    public final List<String> subtitle;
    public boolean alwaysInvisible;
    public String defaultQuestShape;
    public final List<ChapterImage> images;
    public boolean defaultHideDependencyLines;

    public Chapter(QuestFile f, ChapterGroup g) {
        this.file = f;
        this.group = g;
        this.filename = "";
        this.quests = new ArrayList<Quest>();
        this.subtitle = new ArrayList<String>(0);
        this.alwaysInvisible = false;
        this.defaultQuestShape = "";
        this.images = new ArrayList<ChapterImage>();
        this.defaultHideDependencyLines = false;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.group.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this;
    }

    @Override
    public void writeData(class_2487 nbt) {
        class_2499 list;
        nbt.method_10582("filename", this.filename);
        super.writeData(nbt);
        if (!this.subtitle.isEmpty()) {
            list = new class_2499();
            for (String v : this.subtitle) {
                list.add((Object)class_2519.method_23256((String)v));
            }
            nbt.method_10566("subtitle", (class_2520)list);
        }
        if (this.alwaysInvisible) {
            nbt.method_10556("always_invisible", true);
        }
        nbt.method_10582("default_quest_shape", this.defaultQuestShape);
        nbt.method_10556("default_hide_dependency_lines", this.defaultHideDependencyLines);
        if (!this.images.isEmpty()) {
            list = new class_2499();
            for (ChapterImage image : this.images) {
                SNBTCompoundTag nbt1 = new SNBTCompoundTag();
                image.writeData((class_2487)nbt1);
                list.add((Object)nbt1);
            }
            nbt.method_10566("images", (class_2520)list);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        this.filename = nbt.method_10558("filename");
        super.readData(nbt);
        this.subtitle.clear();
        class_2499 subtitleNBT = nbt.method_10554("subtitle", 8);
        for (int i = 0; i < subtitleNBT.size(); ++i) {
            this.subtitle.add(subtitleNBT.method_10608(i));
        }
        this.alwaysInvisible = nbt.method_10577("always_invisible");
        this.defaultQuestShape = nbt.method_10558("default_quest_shape");
        if (this.defaultQuestShape.equals("default")) {
            this.defaultQuestShape = "";
        }
        this.defaultHideDependencyLines = nbt.method_10577("default_hide_dependency_lines");
        class_2499 imgs = nbt.method_10554("images", 10);
        this.images.clear();
        for (int i = 0; i < imgs.size(); ++i) {
            ChapterImage image = new ChapterImage(this);
            image.readData(imgs.method_10602(i));
            this.images.add(image);
        }
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.filename, Short.MAX_VALUE);
        NetUtils.writeStrings(buffer, this.subtitle);
        buffer.writeBoolean(this.alwaysInvisible);
        buffer.method_10788(this.defaultQuestShape, Short.MAX_VALUE);
        NetUtils.write(buffer, this.images, (d, img) -> img.writeNetData((class_2540)d));
        buffer.writeBoolean(this.defaultHideDependencyLines);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.filename = buffer.method_10800(Short.MAX_VALUE);
        NetUtils.readStrings(buffer, this.subtitle);
        this.alwaysInvisible = buffer.readBoolean();
        this.defaultQuestShape = buffer.method_10800(Short.MAX_VALUE);
        NetUtils.read(buffer, this.images, d -> {
            ChapterImage image = new ChapterImage(this);
            image.readNetData((class_2540)d);
            return image;
        });
        this.defaultHideDependencyLines = buffer.readBoolean();
    }

    public int getIndex() {
        return this.group.chapters.indexOf(this);
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        if (this.alwaysInvisible) {
            return 100;
        }
        if (this.quests.isEmpty()) {
            return 100;
        }
        int progress = 0;
        int count = 0;
        for (Quest quest : this.quests) {
            if (quest.isProgressionIgnored()) continue;
            progress += data.getRelativeProgress(quest);
            ++count;
        }
        if (count <= 0) {
            return 100;
        }
        return Chapter.getRelativeProgressFromChildren(progress, count);
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.teamData.setStarted(this.id, data.time);
        ((EventActor)ObjectStartedEvent.CHAPTER.invoker()).act((Object)new ObjectStartedEvent.ChapterEvent(data.withObject(this)));
        if (!data.teamData.isStarted(this.file)) {
            this.file.onStarted(data.withObject(this.file));
        }
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        ((EventActor)ObjectCompletedEvent.CHAPTER.invoker()).act((Object)new ObjectCompletedEvent.ChapterEvent(data.withObject(this)));
        if (!this.disableToast) {
            for (class_3222 player : data.notifiedPlayers) {
                new DisplayCompletionToastMessage(this.id).sendTo(player);
            }
        }
        for (ChapterGroup g : this.file.chapterGroups) {
            for (Chapter chapter : g.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.dependencies.contains(this)) continue;
                    data.teamData.checkAutoCompletion(quest);
                }
            }
        }
        if (this.group.isCompletedRaw(data.teamData)) {
            this.group.onCompleted(data.withObject(this.group));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return new class_2588("ftbquests.unnamed");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.group.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            String s;
            this.filename = s = Chapter.titleToID(this.title).orElse(this.toString());
            Set existingNames = this.group.chapters.stream().map(ch -> ch.filename).collect(Collectors.toSet());
            int i = 2;
            while (existingNames.contains(this.filename)) {
                this.filename = s + "_" + i;
                ++i;
            }
        }
        this.group.chapters.add(this);
        if (!this.quests.isEmpty()) {
            ArrayList<Quest> l = new ArrayList<Quest>(this.quests);
            this.quests.clear();
            for (Quest quest : l) {
                quest.onCreated();
            }
        }
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = Chapter.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public String getPath() {
        return "chapters/" + this.getFilename() + ".snbt";
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("subtitle", this.subtitle, (ConfigValue)new StringConfig(null), (Object)"");
        config.addBool("always_invisible", this.alwaysInvisible, v -> {
            this.alwaysInvisible = v;
        }, false);
        config.addEnum("default_quest_shape", (Object)(this.defaultQuestShape.isEmpty() ? "default" : this.defaultQuestShape), v -> {
            this.defaultQuestShape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addBool("default_hide_dependency_lines", this.defaultHideDependencyLines, v -> {
            this.defaultHideDependencyLines = v;
        }, false);
    }

    @Override
    public boolean isVisible(TeamData data) {
        if (this.alwaysInvisible) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (!quest.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
    }

    @Override
    protected void verifyDependenciesInternal(long original, int depth) {
        if (depth >= 1000) {
            throw new DependencyDepthException(this);
        }
        for (Quest quest : this.quests) {
            if (quest.id == original) {
                throw new DependencyLoopException(this);
            }
            quest.verifyDependenciesInternal(original, depth + 1);
        }
    }

    public boolean hasGroup() {
        return !this.group.isDefaultGroup();
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape.isEmpty() ? this.file.getDefaultQuestShape() : this.defaultQuestShape;
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.quests;
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        for (Quest quest : this.quests) {
            if (!teamData.hasUnclaimedRewards(player, quest)) continue;
            return true;
        }
        return false;
    }
}

