/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.loot.EntityWeight;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class LootCrate {
    public static Map<String, LootCrate> LOOT_CRATES = new LinkedHashMap<String, LootCrate>();
    public final RewardTable table;
    public String stringID;
    public String itemName;
    public Color4I color;
    public boolean glow;
    public EntityWeight drops;

    public LootCrate(RewardTable t) {
        this.table = t;
        this.stringID = t.toString();
        this.itemName = "";
        this.color = Color4I.WHITE;
        this.glow = false;
        this.drops = new EntityWeight();
    }

    public void writeData(class_2487 nbt) {
        nbt.method_10582("string_id", this.stringID);
        if (!this.itemName.isEmpty()) {
            nbt.method_10582("item_name", this.itemName);
        }
        nbt.method_10569("color", this.color.rgb());
        if (this.glow) {
            nbt.method_10556("glow", true);
        }
        class_2487 nbt1 = new class_2487();
        this.drops.writeData(nbt1);
        nbt.method_10566("drops", (class_2520)nbt1);
    }

    public void readData(class_2487 nbt) {
        this.stringID = nbt.method_10558("string_id");
        this.itemName = nbt.method_10558("item_name");
        this.color = Color4I.rgb((int)nbt.method_10550("color"));
        this.glow = nbt.method_10577("glow");
        this.drops.readData(nbt.method_10562("drops"));
    }

    public void writeNetData(class_2540 data) {
        data.method_10788(this.stringID, Short.MAX_VALUE);
        data.method_10788(this.itemName, Short.MAX_VALUE);
        data.writeInt(this.color.rgb());
        data.writeBoolean(this.glow);
        this.drops.writeNetData(data);
    }

    public void readNetData(class_2540 data) {
        this.stringID = data.method_10800(Short.MAX_VALUE);
        this.itemName = data.method_10800(Short.MAX_VALUE);
        this.color = Color4I.rgb((int)data.readInt());
        this.glow = data.readBoolean();
        this.drops.readNetData(data);
    }

    public void getConfig(ConfigGroup config) {
        config.addString("id", this.stringID, v -> {
            this.stringID = v;
        }, "", Pattern.compile("[a-z0-9_]+"));
        config.addString("item_name", this.itemName, v -> {
            this.itemName = v;
        }, "");
        config.addString("color", this.color.toString(), v -> {
            this.color = Color4I.fromString((String)v);
        }, "#FFFFFF", Pattern.compile("^#[a-fA-F0-9]{6}$"));
        config.addBool("glow", this.glow, v -> {
            this.glow = v;
        }, true);
        ConfigGroup d = config.getGroup("drops");
        d.setNameKey("ftbquests.loot.entitydrops");
        d.addInt("passive", this.drops.passive, v -> {
            this.drops.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.passive");
        d.addInt("monster", this.drops.monster, v -> {
            this.drops.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.monster");
        d.addInt("boss", this.drops.boss, v -> {
            this.drops.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.boss");
    }

    public String getStringID() {
        return this.stringID.isEmpty() ? QuestObjectBase.getCodeString(this.table) : this.stringID;
    }

    public class_1799 createStack() {
        class_1799 stack = new class_1799((class_1935)FTBQuestsItems.LOOTCRATE.get());
        stack.method_7959("type", (class_2520)class_2519.method_23256((String)this.getStringID()));
        return stack;
    }
}

