/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.EditRewardTableScreen;
import dev.ftb.mods.ftbquests.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public final class RewardTable
extends QuestObjectBase {
    public final QuestFile file;
    public final List<WeightedReward> rewards;
    public final Quest fakeQuest;
    public int emptyWeight;
    public int lootSize;
    public boolean hideTooltip;
    public boolean useTitle;
    public LootCrate lootCrate;
    public class_2960 lootTableId;
    public String filename;

    public RewardTable(QuestFile f) {
        this.file = f;
        this.rewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(new Chapter(this.file, f.defaultChapterGroup));
        this.emptyWeight = 0;
        this.lootSize = 1;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
        this.lootTableId = null;
        this.filename = "";
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    public int getTotalWeight(boolean includeEmpty) {
        int w = includeEmpty ? this.emptyWeight : 0;
        for (WeightedReward r : this.rewards) {
            w += r.weight;
        }
        return w;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0) {
            nbt.method_10569("empty_weight", this.emptyWeight);
        }
        nbt.method_10569("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.method_10556("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.method_10556("use_title", true);
        }
        class_2499 list = new class_2499();
        for (WeightedReward reward : this.rewards) {
            SNBTCompoundTag nbt1 = new SNBTCompoundTag();
            reward.reward.writeData((class_2487)nbt1);
            if (reward.reward.getType() != RewardTypes.ITEM) {
                nbt1.method_10582("type", reward.reward.getType().getTypeForNBT());
            } else if (nbt1.method_10540("item") == 8) {
                nbt1.singleLine();
            }
            if (reward.weight != 1) {
                nbt1.method_10569("weight", reward.weight);
            }
            list.add((Object)nbt1);
        }
        nbt.method_10566("rewards", (class_2520)list);
        if (this.lootCrate != null) {
            class_2487 nbt1 = new class_2487();
            this.lootCrate.writeData(nbt1);
            nbt.method_10566("loot_crate", (class_2520)nbt1);
        }
        if (this.lootTableId != null) {
            nbt.method_10582("loot_table_id", this.lootTableId.toString());
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.method_10550("empty_weight");
        this.lootSize = nbt.method_10550("loot_size");
        this.hideTooltip = nbt.method_10577("hide_tooltip");
        this.useTitle = nbt.method_10577("use_title");
        this.rewards.clear();
        class_2499 list = nbt.method_10554("rewards", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbt1 = list.method_10602(i);
            Reward reward = RewardType.createReward(this.fakeQuest, nbt1.method_10558("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.rewards.add(new WeightedReward(reward, nbt1.method_10545("weight") ? nbt1.method_10550("weight") : 1));
        }
        this.lootCrate = null;
        if (nbt.method_10545("loot_crate")) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readData(nbt.method_10562("loot_crate"));
        }
        this.lootTableId = nbt.method_10545("loot_table_id") ? new class_2960(nbt.method_10558("loot_table_id")) : null;
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.filename, Short.MAX_VALUE);
        buffer.method_10804(this.emptyWeight);
        buffer.method_10804(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.lootTableId != null ? 1 : 0) != 0);
        buffer.method_10804(flags);
        buffer.method_10804(this.rewards.size());
        for (WeightedReward reward : this.rewards) {
            buffer.method_10804(reward.reward.getType().intId);
            reward.reward.writeNetData(buffer);
            buffer.method_10804(reward.weight);
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(buffer);
        }
        if (this.lootTableId != null) {
            buffer.method_10812(this.lootTableId);
        }
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.filename = buffer.method_10800(Short.MAX_VALUE);
        this.emptyWeight = buffer.method_10816();
        this.lootSize = buffer.method_10816();
        int flags = buffer.method_10816();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        boolean hasLootTableId = Bits.getFlag((int)flags, (int)8);
        this.rewards.clear();
        int s = buffer.method_10816();
        for (int i = 0; i < s; ++i) {
            RewardType type = (RewardType)((Object)this.file.rewardTypeIds.get(buffer.method_10816()));
            Reward reward = type.provider.create(this.fakeQuest);
            reward.readNetData(buffer);
            int w = buffer.method_10816();
            this.rewards.add(new WeightedReward(reward, w));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readNetData(buffer);
        }
        this.lootTableId = hasLootTableId ? buffer.method_10810() : null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("empty_weight", this.emptyWeight, v -> {
            this.emptyWeight = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("loot_size", this.lootSize, v -> {
            this.lootSize = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            this.lootCrate.getConfig(config.getGroup("loot_crate").setNameKey("item.ftbquests.lootcrate.name"));
        }
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (WeightedReward reward : this.rewards) {
            reward.reward.clearCachedData();
        }
    }

    @Override
    public void deleteSelf() {
        this.file.rewardTables.remove(this);
        super.deleteSelf();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.viewQuestPanel.refreshWidgets();
        } else {
            RewardTablesScreen gui1 = (RewardTablesScreen)((Object)ClientUtils.getCurrentGuiAs(RewardTablesScreen.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
        this.file.updateLootCrates();
    }

    @Override
    public void editedFromGUIOnServer() {
        this.file.updateLootCrates();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            String s;
            this.filename = s = RewardTable.titleToID(this.title).orElse(this.toString());
            Set existingNames = this.file.rewardTables.stream().map(rt -> rt.filename).collect(Collectors.toSet());
            int i = 2;
            while (existingNames.contains(this.filename)) {
                this.filename = s + "_" + i;
                ++i;
            }
        }
        this.file.rewardTables.add(this);
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = RewardTable.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public String getPath() {
        return "reward_tables/" + this.getFilename() + ".snbt";
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        if (this.rewards.size() == 1) {
            return this.rewards.get((int)0).reward.getTitle();
        }
        return new class_2588("ftbquests.reward_table");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((class_1799)this.lootCrate.createStack());
        }
        if (this.rewards.isEmpty()) {
            return Icons.DICE;
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (WeightedReward reward : this.rewards) {
            icons.add(reward.reward.getIcon());
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        new EditRewardTableScreen(this, () -> new EditObjectMessage(this).sendToServer()).openGui();
    }

    public void addMouseOverText(TooltipList list, boolean includeWeight, boolean includeEmpty) {
        List<WeightedReward> rewards1;
        if (this.hideTooltip) {
            return;
        }
        int totalWeight = this.getTotalWeight(includeEmpty);
        if (includeWeight && includeEmpty && this.emptyWeight > 0) {
            list.add((class_2561)new class_2585("").method_27692(class_124.field_1080).method_27693("- ").method_10852((class_2561)new class_2588("ftbquests.reward_table.nothing")).method_10852((class_2561)new class_2585(" [" + WeightedReward.chanceString(this.emptyWeight, totalWeight, true) + "]").method_27692(class_124.field_1063)));
        }
        if (this.rewards.size() > 1) {
            rewards1 = new ArrayList<WeightedReward>(this.rewards);
            rewards1.sort(null);
        } else {
            rewards1 = this.rewards;
        }
        for (int i = 0; i < rewards1.size(); ++i) {
            if (i == 10) {
                list.add((class_2561)new class_2585("").method_27692(class_124.field_1080).method_27693("- ").method_10852((class_2561)new class_2588("ftbquests.reward_table.and_more", new Object[]{rewards1.size() - 10})));
                return;
            }
            WeightedReward r = rewards1.get(i);
            if (includeWeight) {
                list.add((class_2561)new class_2585("").method_27692(class_124.field_1080).method_27693("- ").method_10852(r.reward.getTitle()).method_10852((class_2561)new class_2585(" [" + WeightedReward.chanceString(r.weight, totalWeight) + "]").method_27692(class_124.field_1063)));
                continue;
            }
            list.add((class_2561)new class_2585("").method_27692(class_124.field_1080).method_27693("- ").method_10852(r.reward.getTitle()));
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.LOOTCRATES;
    }
}

