/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.brigadier.StringReader;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import me.shedaniel.architectury.registry.Registries;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2247;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_5321;

public class ObservationTask
extends BooleanTask {
    public long timer = 0L;
    public ObserveType observeType = ObserveType.BLOCK;
    public String toObserve = "minecraft:dirt";

    public ObservationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.OBSERVATION;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10544("timer", this.timer);
        nbt.method_10569("observe_type", this.observeType.ordinal());
        nbt.method_10582("to_observe", this.toObserve);
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.timer = nbt.method_10537("timer");
        this.observeType = ObserveType.values()[nbt.method_10550("observe_type")];
        this.toObserve = nbt.method_10558("to_observe");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10791(this.timer);
        buffer.method_10817((Enum)this.observeType);
        buffer.method_10814(this.toObserve);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.timer = buffer.method_10792();
        this.observeType = (ObserveType)buffer.method_10818(ObserveType.class);
        this.toObserve = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("timer", this.timer, v -> {
            this.timer = v;
        }, 0L, 0L, 1200L);
        config.addEnum("observe_type", (Object)this.observeType, v -> {
            this.observeType = v;
        }, ObserveType.NAME_MAP);
        config.addString("to_observe", this.toObserve, v -> {
            this.toObserve = v;
        }, "minecraft:dirt");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        return true;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    public boolean observe(class_1657 player, class_239 result) {
        if (this.toObserve.isEmpty()) {
            return false;
        }
        if (result instanceof class_3965) {
            class_3965 blockResult = (class_3965)result;
            class_2694 blockInWorld = new class_2694((class_4538)player.field_6002, blockResult.method_17777(), false);
            class_2680 state = blockInWorld.method_11681();
            class_2248 block = state.method_26204();
            class_2586 blockEntity = blockInWorld.method_11680();
            switch (this.observeType) {
                case BLOCK: {
                    return String.valueOf(Registries.getId((Object)block, (class_5321)class_2378.field_25105)).equals(this.toObserve);
                }
                case BLOCK_TAG: {
                    return state.method_26164(class_3481.method_15073().method_30213(new class_2960(this.toObserve)));
                }
                case BLOCK_STATE: {
                    class_2247 stateMatch = this.tryMatchBlock(this.toObserve, false);
                    return stateMatch != null && stateMatch.method_9493(blockInWorld);
                }
                case BLOCK_ENTITY: {
                    class_2247 stateNbtMatch = this.tryMatchBlock(this.toObserve, true);
                    return stateNbtMatch != null && stateNbtMatch.method_9493(blockInWorld);
                }
                case BLOCK_ENTITY_TYPE: {
                    return blockEntity != null && this.toObserve.equals(String.valueOf(Registries.getId((Object)blockEntity.method_11017(), (class_5321)class_2378.field_25073)));
                }
            }
            return false;
        }
        if (result instanceof class_3966) {
            class_3966 entityResult = (class_3966)result;
            if (this.observeType == ObserveType.ENTITY_TYPE) {
                return this.toObserve.equals(String.valueOf(Registries.getId((Object)entityResult.method_17782().method_5864(), (class_5321)class_2378.field_25107)));
            }
            if (this.observeType == ObserveType.ENTITY_TYPE_TAG) {
                return entityResult.method_17782().method_5864().method_20210(class_3483.method_15082().method_30213(new class_2960(this.toObserve)));
            }
        }
        return false;
    }

    private class_2247 tryMatchBlock(String string, boolean parseNbt) {
        try {
            class_2259 blockStateParser = new class_2259(new StringReader(string), false).method_9678(parseNbt);
            return new class_2247(blockStateParser.method_9669(), blockStateParser.method_9692().keySet(), blockStateParser.method_9694());
        }
        catch (Exception ex) {
            return null;
        }
    }

    static enum ObserveType {
        BLOCK,
        BLOCK_TAG,
        BLOCK_STATE,
        BLOCK_ENTITY,
        BLOCK_ENTITY_TYPE,
        ENTITY_TYPE,
        ENTITY_TYPE_TAG;

        public static final NameMap<ObserveType> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)BLOCK), (Object[])ObserveType.values()).id(v -> v.name().toLowerCase()).create();
        }
    }
}

