/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.architectury.core.RegistryEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class TaskType
extends RegistryEntry<TaskType> {
    public final class_2960 id;
    public final Provider provider;
    private final Supplier<Icon> icon;
    private class_2561 displayName;
    private GuiProvider guiProvider;
    public int intId;

    @Nullable
    public static Task createTask(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        TaskType type = TaskTypes.TYPES.get(new class_2960(id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    TaskType(class_2960 i, Provider p, Supplier<Icon> ic) {
        this.id = i;
        this.provider = p;
        this.icon = ic;
        this.displayName = null;
        this.guiProvider = new GuiProvider(){

            @Override
            @Environment(value=EnvType.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Task> callback) {
                Task task = TaskType.this.provider.create(quest);
                if (task instanceof ISingleLongValueTask) {
                    ISingleLongValueTask t = (ISingleLongValueTask)((Object)task);
                    LongConfig c = new LongConfig(t.getMinConfigValue(), t.getMaxConfigValue());
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)t.getDefaultConfigValue(), (Object)t.getDefaultConfigValue(), accepted -> {
                        if (accepted) {
                            ((ISingleLongValueTask)((Object)task)).setValue((Long)c.value);
                            callback.accept(task);
                        }
                        gui.run();
                    });
                    return;
                }
                ConfigGroup group = new ConfigGroup("ftbquests");
                task.getConfig(task.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(task);
                    }
                    gui.run();
                };
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.id.method_12836().equals("ftbquests") ? this.id.method_12832() : this.id.toString();
    }

    public TaskType setDisplayName(class_2561 name) {
        this.displayName = name;
        return this;
    }

    public class_2561 getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new class_2588("ftbquests.task." + this.id.method_12836() + '.' + this.id.method_12832());
        }
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.get();
    }

    public TaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public static interface GuiProvider {
        @Environment(value=EnvType.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Task> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public Task create(Quest var1);
    }
}

