/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.RenderUtil;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.EnergyTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.minecraft.class_1058;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;

public class TaskScreenRenderer
implements class_827<TaskScreenBlockEntity> {
    public static final class_2960 INPUT_ONLY_TEXTURE = new class_2960("ftbquests", "tasks/input_only");
    public static final class_2960 TANK_TEXTURE = new class_2960("ftbquests", "tasks/tank");
    public static final class_2960 FE_ENERGY_EMPTY_TEXTURE = new class_2960("ftbquests", "tasks/fe_empty");
    public static final class_2960 FE_ENERGY_FULL_TEXTURE = new class_2960("ftbquests", "tasks/fe_full");
    public static final class_2960 TR_ENERGY_EMPTY_TEXTURE = new class_2960("ftbquests", "tasks/ic2_empty");
    public static final class_2960 TR_ENERGY_FULL_TEXTURE = new class_2960("ftbquests", "tasks/ic2_full");
    private final class_5614.class_5615 context;

    public TaskScreenRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public int method_33893() {
        return 64;
    }

    public boolean shouldRender(TaskScreenBlockEntity blockEntity, class_243 vec3) {
        return super.method_33892((class_2586)blockEntity, vec3);
    }

    public void render(TaskScreenBlockEntity taskScreen, float partialTicks, class_4587 poseStack, class_4597 multiBufferSource, int combinedLight, int combinedOverlay) {
        class_2248 class_22482;
        if (!ClientQuestFile.exists() || !((class_22482 = taskScreen.method_11010().method_26204()) instanceof TaskScreenBlock)) {
            return;
        }
        TaskScreenBlock taskScreenBlock = (TaskScreenBlock)class_22482;
        TeamData data = ClientQuestFile.INSTANCE.getNullableTeamData(taskScreen.getTeamId());
        Task task = taskScreen.getTask();
        if (task == null || data == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        float rotation = ((class_2350)taskScreen.method_11010().method_11654((class_2769)class_2551.field_11726)).method_10144() + 180.0f;
        poseStack.method_22907(class_1160.field_20707.method_23214(180.0f));
        poseStack.method_22907(class_1160.field_20705.method_23214(rotation));
        poseStack.method_22904(-0.5, -0.5, -0.5);
        int size = taskScreenBlock.getSize() / 2;
        poseStack.method_22904((double)(-size), (double)((float)(-size) * 2.0f), (double)-0.02f);
        poseStack.method_22905((float)size * 2.0f + 1.0f, (float)size * 2.0f + 1.0f, 1.0f);
        class_327 font = this.context.method_32143();
        double iconY = 0.5;
        class_2561 top1 = taskScreen.isInputOnly() ? class_2585.field_24366 : task.quest.getTitle();
        class_2561 top2 = taskScreen.isInputOnly() ? class_2585.field_24366 : task.getTitle();
        this.drawString(taskScreen, font, poseStack, top1, 0.02, 0.15);
        if (top2 != class_2585.field_24366) {
            this.drawString(taskScreen, font, poseStack, top2, 0.17, 0.07);
            iconY = 0.54;
        }
        if (!taskScreen.isInputOnly() && !task.hideProgressNumbers()) {
            long progress = data.getProgress(task);
            class_124 col = progress == 0L ? class_124.field_1065 : (progress < task.getMaxProgress() ? class_124.field_1054 : class_124.field_1060);
            class_5250 txt = new class_2585(task.formatProgress(data, progress) + " / " + task.formatMaxProgress()).method_27692(col);
            this.drawString(taskScreen, font, poseStack, (class_2561)txt, 0.83, 0.15);
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, iconY, -0.01);
        poseStack.method_22905(taskScreen.isInputOnly() ? 0.5f : 0.45f, taskScreen.isInputOnly() ? 0.5f : 0.45f, 0.2f * (float)size);
        poseStack.method_22907(class_1160.field_20707.method_23214(180.0f));
        if (taskScreen.isInputOnly() && !taskScreen.getInputModeIcon().method_7960()) {
            this.drawTaskIcon(taskScreen, data, ItemIcon.getItemIcon((class_1799)taskScreen.getInputModeIcon()), poseStack, multiBufferSource);
        } else {
            this.drawTaskIcon(taskScreen, data, task.getIcon(), poseStack, multiBufferSource);
        }
        poseStack.method_22909();
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23028((class_2960)class_1723.field_21668));
        float[] f = taskScreen.getFakeTextureUV();
        if (f != null && f.length == 4) {
            poseStack.method_22903();
            poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
            poseStack.method_22904(0.0, 0.0, (double)0.01f);
            RenderUtil.create(poseStack, vertexConsumer, 0.0f, 0.0f).withUV(f[0], f[1], f[2], f[3]).draw();
            poseStack.method_22909();
        }
        if (taskScreen.isInputOnly() && FTBQuestsClientEventHandler.inputOnlySprite != null) {
            class_1058 s = FTBQuestsClientEventHandler.inputOnlySprite;
            poseStack.method_22903();
            poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
            RenderUtil.create(poseStack, vertexConsumer, 0.0f, 0.0f).withUV(s.method_4594(), s.method_4593(), s.method_4577(), s.method_4575()).draw();
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    /*
     * Unable to fully structure code
     */
    private void drawTaskIcon(TaskScreenBlockEntity taskScreen, TeamData data, Icon icon, class_4587 poseStack, class_4597 buffer) {
        vertexConsumer = buffer.getBuffer(class_1921.method_23028((class_2960)class_1723.field_21668));
        task = taskScreen.getTask();
        progress = data.getProgress(task);
        poseStack.method_22903();
        poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        if (!(task instanceof FluidTask) || !((var15_10 = (fluidTask = (FluidTask)task).getIcon()) instanceof AtlasSpriteIcon)) ** GOTO lbl-1000
        as = (AtlasSpriteIcon)var15_10;
        if (FTBQuestsClientEventHandler.tankSprite != null) {
            sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(as.id);
            if (progress > 0L) {
                heightInterpolated = 16.0f * (float)((double)progress / (double)task.getMaxProgress());
                RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withColor(FluidStackHooks.getColor((class_3611)fluidTask.fluid) | -16777216).withSize(16.0f, heightInterpolated).withUV(sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4570((double)heightInterpolated)).draw();
            }
            s = FTBQuestsClientEventHandler.tankSprite;
            poseStack.method_22904(0.0, 0.0, -0.05000000074505806);
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(s.method_4594(), s.method_4593(), s.method_4577(), s.method_4575()).draw();
        } else if (task instanceof EnergyTask) {
            energyTask = (EnergyTask)task;
            empty = energyTask.getClientData().getEmptyTexture();
            full = energyTask.getClientData().getFullTexture();
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(empty.method_4594(), empty.method_4593(), empty.method_4577(), empty.method_4575()).draw();
            if (progress > 0L) {
                heightInterpolated = 16.0f * (float)((double)progress / (double)task.getMaxProgress());
                poseStack.method_22904(0.0, 0.0, -0.05000000074505806);
                RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withSize(16.0f, heightInterpolated).withUV(full.method_4594(), full.method_4593(), full.method_4577(), full.method_4570((double)heightInterpolated)).draw();
            }
        } else if (icon instanceof ItemIcon) {
            itemIcon = (ItemIcon)icon;
            poseStack.method_22905(16.0f, 16.0f, 16.0f);
            class_310.method_1551().method_1480().method_23178(itemIcon.getStack(), class_809.class_811.field_4319, 0xF000F0, class_4608.field_21444, poseStack, buffer, 0);
        } else if (icon instanceof AtlasSpriteIcon) {
            spriteIcon = (AtlasSpriteIcon)icon;
            sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(spriteIcon.id);
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575()).draw();
        }
        poseStack.method_22909();
    }

    private void drawString(TaskScreenBlockEntity taskScreen, class_327 font, class_4587 poseStack, class_2561 text, double y, double size) {
        if (text != class_2585.field_24366) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, y, 0.0);
            int len = font.method_27525((class_5348)text);
            float scale = (float)(size / 9.0);
            double width = (float)len * scale;
            if (width > 1.0) {
                scale = (float)((double)scale / width);
                width = 1.0;
            }
            if (width > 0.9) {
                scale = (float)((double)scale * 0.9);
            }
            poseStack.method_22905(scale, scale, 1.0f);
            if (taskScreen.isTextShadow()) {
                font.method_30881(poseStack, text, (float)(-len) / 2.0f, 0.0f, -2565928);
            } else {
                font.method_30883(poseStack, text, (float)(-len) / 2.0f, 0.0f, -2565928);
            }
            poseStack.method_22909();
        }
    }
}

